/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassFromUsageBaseFix;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateClassKind;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateFromUsageUtils;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class CreateClassFromUsageFix
extends CreateClassFromUsageBaseFix {
    public CreateClassFromUsageFix(PsiJavaCodeReferenceElement refElement, CreateClassKind kind) {
        super(kind, refElement);
    }

    @Override
    public String getText(String varName) {
        return QuickFixBundle.message("create.class.from.usage.text", this.myKind.getDescription(), varName);
    }

    public void invoke(final @NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/CreateClassFromUsageFix", "invoke"));
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        final PsiJavaCodeReferenceElement element = this.getRefElement();
        if (element == null) {
            return;
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)element)) {
            return;
        }
        String superClassName = this.getSuperClassName(element);
        final PsiClass aClass = CreateFromUsageUtils.createClass(element, this.myKind, superClassName);
        if (aClass == null) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiJavaCodeReferenceElement refElement = element;
                try {
                    refElement = (PsiJavaCodeReferenceElement)refElement.bindToElement((PsiElement)aClass);
                }
                catch (IncorrectOperationException e) {
                    CreateClassFromUsageBaseFix.LOG.error((Throwable)e);
                }
                IdeDocumentHistory.getInstance(project2).includeCurrentPlaceAsChangePlace();
                OpenFileDescriptor descriptor = new OpenFileDescriptor(refElement.getProject(), aClass.getContainingFile().getVirtualFile(), aClass.getTextOffset());
                FileEditorManager.getInstance((Project)aClass.getProject()).openTextEditor(descriptor, true);
            }
        });
    }

    public boolean startInWriteAction() {
        return false;
    }
}

