/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import java.util.ArrayList;
import java.util.List;

public class CodeBlockOrInitializerSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiCodeBlock || e instanceof PsiArrayInitializerExpression;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.add(e.getTextRange());
        PsiElement[] children2 = e.getChildren();
        if (children2.length > 0) {
            int start = CodeBlockOrInitializerSelectioner.findOpeningBrace(children2);
            int end = CodeBlockOrInitializerSelectioner.findClosingBrace(children2, start);
            result.addAll(CodeBlockOrInitializerSelectioner.expandToWholeLine(editorText, new TextRange(start, end)));
        }
        return result;
    }

    public static int findOpeningBrace(PsiElement[] children2) {
        int start = 0;
        for (int i = 0; i < children2.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children2[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.LBRACE) continue;
            int j = i + 1;
            while (children2[j] instanceof PsiWhiteSpace) {
                ++j;
            }
            start = children2[j].getTextRange().getStartOffset();
        }
        return start;
    }

    public static int findClosingBrace(PsiElement[] children2, int startOffset) {
        int end = children2[children2.length - 1].getTextRange().getEndOffset();
        for (int i = 0; i < children2.length; ++i) {
            PsiJavaToken token;
            PsiElement child = children2[i];
            if (!(child instanceof PsiJavaToken) || (token = (PsiJavaToken)child).getTokenType() != JavaTokenType.RBRACE) continue;
            int j = i - 1;
            while (children2[j] instanceof PsiWhiteSpace && children2[j].getTextRange().getStartOffset() > startOffset) {
                --j;
            }
            end = children2[j].getTextRange().getEndOffset();
        }
        return end;
    }
}

