/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.FoldingUtil;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseExpandToLevelAction
extends EditorAction {
    protected BaseExpandToLevelAction(final int level, final boolean expandAll) {
        super((EditorActionHandler)new BaseFoldingHandler(){

            protected void doExecute(final Editor editor, @Nullable Caret caret, DataContext dataContext) {
                assert (editor.getProject() != null);
                CodeFoldingManager foldingManager = CodeFoldingManager.getInstance(editor.getProject());
                foldingManager.updateFoldRegions(editor);
                if (caret == null) {
                    caret = editor.getCaretModel().getPrimaryCaret();
                }
                int offset = caret.getOffset();
                FoldRegion rootRegion = null;
                if (!expandAll) {
                    FoldRegion[] regions;
                    rootRegion = FoldingUtil.findFoldRegionStartingAtLine(editor, editor.getDocument().getLineNumber(offset));
                    if (rootRegion == null && (regions = FoldingUtil.getFoldRegionsAtOffset(editor, offset)).length > 0) {
                        rootRegion = regions[0];
                    }
                    if (rootRegion == null) {
                        return;
                    }
                }
                final FoldRegion root = rootRegion;
                final int[] rootLevel = new int[]{root == null ? 1 : -1};
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        Iterator<FoldRegion> regionTreeIterator = FoldingUtil.createFoldTreeIterator(editor);
                        LinkedList<FoldRegion> currentStack = new LinkedList<FoldRegion>();
                        while (regionTreeIterator.hasNext()) {
                            FoldRegion region = regionTreeIterator.next();
                            while (!currentStack.isEmpty() && !BaseExpandToLevelAction.isChild((FoldRegion)currentStack.peek(), region)) {
                                if (currentStack.remove() != root) continue;
                                rootLevel[0] = -1;
                            }
                            currentStack.push(region);
                            int currentLevel = currentStack.size();
                            if (region == root) {
                                rootLevel[0] = currentLevel;
                            }
                            if (rootLevel[0] < 0) continue;
                            int relativeLevel = currentLevel - rootLevel[0];
                            if (relativeLevel < level) {
                                region.setExpanded(true);
                                continue;
                            }
                            if (relativeLevel != level) continue;
                            region.setExpanded(false);
                        }
                    }
                });
            }
        });
    }

    private static boolean isChild(@NotNull FoldRegion parent, @NotNull FoldRegion child) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/codeInsight/folding/impl/actions/BaseExpandToLevelAction", "isChild"));
        }
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child", "com/intellij/codeInsight/folding/impl/actions/BaseExpandToLevelAction", "isChild"));
        }
        return child.getStartOffset() >= parent.getStartOffset() && child.getEndOffset() <= parent.getEndOffset();
    }
}

