/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.folding.impl.actions;

import com.intellij.codeInsight.folding.CodeFoldingManager;
import com.intellij.codeInsight.folding.impl.actions.BaseFoldingHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class CollapseAllRegionsAction
extends EditorAction {
    public CollapseAllRegionsAction() {
        super((EditorActionHandler)new BaseFoldingHandler(){

            public void doExecute(Editor editor, @Nullable Caret caret, DataContext dataContext) {
                Project project2 = editor.getProject();
                assert (project2 != null);
                PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
                CodeFoldingManager.getInstance(project2).updateFoldRegions(editor);
                final List<FoldRegion> regions = this.getFoldRegionsForSelection(editor, caret);
                editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        for (FoldRegion region : regions) {
                            region.setExpanded(false);
                        }
                    }
                });
            }
        });
    }
}

