/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.hint.api.impls;

import com.intellij.codeInsight.AnnotationTargetUtil;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInsight.javadoc.JavaDocInfoGenerator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.impl.source.resolve.CompletionParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.MethodProcessorSetupFailedException;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.processor.MethodResolverProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<PsiExpressionList, Object, PsiExpression>,
DumbAware {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{PsiMethodCallExpression.class, PsiNewExpression.class, PsiAnonymousClass.class, PsiEnumConstant.class});
    private static final Set<? extends Class> ourStopSearch = Collections.singleton(PsiMethod.class);

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        List<? extends PsiElement> elements = JavaCompletionUtil.getAllPsiElements(item);
        return elements != null && !elements.isEmpty() && elements.get(0) instanceof PsiMethod ? elements.toArray() : null;
    }

    public Object[] getParametersForDocumentation(Object p, ParameterInfoContext context) {
        if (p instanceof MethodCandidateInfo) {
            return ((MethodCandidateInfo)p).getElement().getParameterList().getParameters();
        }
        if (p instanceof PsiMethod) {
            return ((PsiMethod)p).getParameterList().getParameters();
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public boolean couldShowInLookup() {
        return true;
    }

    @Nullable
    public PsiExpressionList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "findElementForParameterInfo"));
        }
        PsiExpressionList argumentList = this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
        if (argumentList != null) {
            return MethodParameterInfoHandler.findMethodsForArgumentList(context, argumentList);
        }
        return null;
    }

    private PsiExpressionList findArgumentList(PsiFile file2, int offset, int parameterStart) {
        PsiMethodCallExpression methodCall;
        PsiExpressionList argumentList = (PsiExpressionList)ParameterInfoUtils.findArgumentList((PsiFile)file2, (int)offset, (int)parameterStart, (ParameterInfoHandlerWithTabActionSupport)this);
        if (argumentList == null && (methodCall = (PsiMethodCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file2, (int)offset, PsiMethodCallExpression.class, (Class[])new Class[]{PsiMethod.class})) != null) {
            argumentList = methodCall.getArgumentList();
        }
        return argumentList;
    }

    private static PsiExpressionList findMethodsForArgumentList(CreateParameterInfoContext context, @NotNull PsiExpressionList argumentList) {
        if (argumentList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "argumentList", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "findMethodsForArgumentList"));
        }
        Object[] candidates = MethodParameterInfoHandler.getMethods(argumentList);
        if (candidates.length == 0) {
            DaemonCodeAnalyzer.getInstance((Project)context.getProject()).updateVisibleHighlighters(context.getEditor());
            return null;
        }
        context.setItemsToShow(candidates);
        return argumentList;
    }

    public void showParameterInfo(@NotNull PsiExpressionList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "showParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "showParameterInfo"));
        }
        context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
    }

    public PsiExpressionList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "findElementForUpdatingParameterInfo"));
        }
        return this.findArgumentList(context.getFile(), context.getOffset(), context.getParameterListStart());
    }

    public void updateParameterInfo(@NotNull PsiExpressionList o, @NotNull UpdateParameterInfoContext context) {
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "updateParameterInfo"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "updateParameterInfo"));
        }
        PsiElement parameterOwner = context.getParameterOwner();
        if (parameterOwner != o) {
            context.removeHint();
            return;
        }
        int index = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)o.getNode(), (int)context.getOffset(), (IElementType)JavaTokenType.COMMA);
        context.setCurrentParameter(index);
        Object[] candidates = context.getObjectsToView();
        PsiExpression[] args = o.getExpressions();
        PsiMethod realResolve = null;
        for (int i = 0; i < candidates.length; ++i) {
            CandidateInfo candidate = (CandidateInfo)candidates[i];
            PsiMethod method = (PsiMethod)candidate.getElement();
            if (!method.isValid()) continue;
            PsiSubstitutor substitutor = MethodParameterInfoHandler.getCandidateInfoSubstitutor(candidate);
            assert (substitutor != null);
            if (!method.isValid() || !substitutor.isValid()) {
                context.setUIComponentEnabled(i, false);
                continue;
            }
            PsiParameter[] parms = method.getParameterList().getParameters();
            boolean enabled = true;
            if (parms.length <= index) {
                if (parms.length > 0) {
                    if (method.isVarArgs()) {
                        for (int j = 0; j < parms.length - 1; ++j) {
                            PsiType parmType = substitutor.substitute(parms[j].getType());
                            PsiType argType = args[j].getType();
                            if (argType == null || parmType.isAssignableFrom(argType)) continue;
                            enabled = false;
                            break;
                        }
                        if (enabled) {
                            PsiArrayType lastParmType = (PsiArrayType)substitutor.substitute(parms[parms.length - 1].getType());
                            PsiType componentType = lastParmType.getComponentType();
                            if (parms.length == args.length) {
                                PsiType lastArgType = args[args.length - 1].getType();
                                if (lastArgType != null && !lastParmType.isAssignableFrom(lastArgType) && !componentType.isAssignableFrom(lastArgType)) {
                                    enabled = false;
                                }
                            } else {
                                for (int j = parms.length; j <= index && j < args.length; ++j) {
                                    PsiExpression arg = args[j];
                                    PsiType argType = arg.getType();
                                    if (argType == null || componentType.isAssignableFrom(argType)) continue;
                                    enabled = false;
                                    break;
                                }
                            }
                        }
                    } else {
                        enabled = false;
                    }
                } else {
                    enabled = index == 0;
                }
            } else {
                enabled = MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, index, substitutor);
            }
            context.setUIComponentEnabled(i, enabled);
            if (candidates.length <= 1 || !enabled || parms.length != args.length || !MethodParameterInfoHandler.isAssignableParametersBeforeGivenIndex(parms, args, args.length, substitutor)) continue;
            if (realResolve == null) {
                PsiCall call = MethodParameterInfoHandler.getCall(o);
                if (call != null) {
                    realResolve = call.resolveMethod();
                }
                if (realResolve == null) {
                    realResolve = PsiUtilCore.NULL_PSI_ELEMENT;
                }
            }
            if (realResolve != PsiUtilCore.NULL_PSI_ELEMENT && realResolve != method) continue;
            context.setHighlightedParameter((Object)candidate);
        }
    }

    private static PsiSubstitutor getCandidateInfoSubstitutor(CandidateInfo candidate) {
        return candidate instanceof MethodCandidateInfo && ((MethodCandidateInfo)candidate).isInferencePossible() ? ((MethodCandidateInfo)candidate).inferTypeArguments((ParameterTypeInferencePolicy)CompletionParameterTypeInferencePolicy.INSTANCE, true) : candidate.getSubstitutor();
    }

    private static boolean isAssignableParametersBeforeGivenIndex(PsiParameter[] parms, PsiExpression[] args, int length, PsiSubstitutor substitutor) {
        for (int j = 0; j < length; ++j) {
            PsiParameter parm = parms[j];
            PsiExpression arg = args[j];
            assert (parm.isValid());
            assert (arg.isValid());
            PsiType parmType = parm.getType();
            PsiType argType = arg.getType();
            if (argType == null) continue;
            if (parmType instanceof PsiEllipsisType && parmType.getArrayDimensions() == argType.getArrayDimensions() + 1) {
                parmType = ((PsiEllipsisType)parmType).getComponentType();
            }
            if ((parmType = substitutor.substitute(parmType)).isAssignableFrom(argType)) continue;
            return false;
        }
        return true;
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    @NotNull
    public Class<PsiExpressionList> getArgumentListClass() {
        if (PsiExpressionList.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getArgumentListClass"));
        }
        return PsiExpressionList.class;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JavaTokenType.RBRACE;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getActualParametersRBraceType"));
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getArgumentListAllowedParentClasses"));
        }
        return set;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<? extends Class> set = ourStopSearch;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getArgListStopSearchClasses"));
        }
        return set;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JavaTokenType.COMMA;
        if (iElementType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getActualParameterDelimiterType"));
        }
        return iElementType;
    }

    @NotNull
    public PsiExpression[] getActualParameters(@NotNull PsiExpressionList psiExpressionList) {
        if (psiExpressionList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiExpressionList", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getActualParameters"));
        }
        PsiExpression[] psiExpressionArray = psiExpressionList.getExpressions();
        if (psiExpressionArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "getActualParameters"));
        }
        return psiExpressionArray;
    }

    private static PsiCall getCall(PsiExpressionList list) {
        PsiElement listParent = list.getParent();
        if (listParent instanceof PsiMethodCallExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiNewExpression) {
            return (PsiCall)listParent;
        }
        if (listParent instanceof PsiAnonymousClass) {
            return (PsiCall)listParent.getParent();
        }
        if (listParent instanceof PsiEnumConstant) {
            return (PsiCall)listParent;
        }
        return null;
    }

    private static CandidateInfo[] getMethods(PsiExpressionList argList) {
        PsiCall call = MethodParameterInfoHandler.getCall(argList);
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)argList.getProject()).getResolveHelper();
        if (call instanceof PsiCallExpression) {
            CandidateInfo[] candidates = MethodParameterInfoHandler.getCandidates((PsiCallExpression)call);
            ArrayList<CandidateInfo> result = new ArrayList<CandidateInfo>();
            if (!(argList.getParent() instanceof PsiAnonymousClass)) {
                block0: for (CandidateInfo candidate : candidates) {
                    PsiMethod methodCandidate = (PsiMethod)candidate.getElement();
                    for (CandidateInfo info : result) {
                        if (!MethodSignatureUtil.isSuperMethod((PsiMethod)methodCandidate, (PsiMethod)((PsiMethod)info.getElement()))) continue;
                        continue block0;
                    }
                    if (!candidate.isStaticsScopeCorrect()) continue;
                    boolean accessible = candidate.isAccessible();
                    if (!accessible && methodCandidate.getModifierList().hasModifierProperty("private")) {
                        accessible = JavaPsiFacade.getInstance((Project)methodCandidate.getProject()).getResolveHelper().isAccessible((PsiMember)methodCandidate, methodCandidate.getModifierList(), (PsiElement)call, null, null);
                    }
                    if (!accessible) continue;
                    result.add(candidate);
                }
            } else {
                PsiClass aClass = (PsiClass)argList.getParent();
                for (CandidateInfo candidate : candidates) {
                    if (!candidate.isStaticsScopeCorrect() || !helper.isAccessible((PsiMember)((PsiMethod)candidate.getElement()), (PsiElement)argList, aClass)) continue;
                    result.add(candidate);
                }
            }
            return result.isEmpty() ? candidates : result.toArray(new CandidateInfo[result.size()]);
        }
        assert (call instanceof PsiEnumConstant);
        PsiMethod[] constructors = ((PsiEnumConstant)call).getContainingClass().getConstructors();
        CandidateInfo[] result = new CandidateInfo[constructors.length];
        for (int i = 0; i < constructors.length; ++i) {
            result[i] = new CandidateInfo((PsiElement)constructors[i], PsiSubstitutor.EMPTY);
        }
        return result;
    }

    private static CandidateInfo[] getCandidates(PsiCallExpression call) {
        MethodResolverProcessor processor2 = new MethodResolverProcessor((PsiElement)call, call.getContainingFile(), new PsiConflictResolver[0]){

            @Override
            protected boolean acceptVarargs() {
                return false;
            }
        };
        try {
            PsiScopesUtil.setupAndRunProcessor(processor2, call, true);
        }
        catch (MethodProcessorSetupFailedException e) {
            return CandidateInfo.EMPTY_ARRAY;
        }
        List<CandidateInfo> results = processor2.getResults();
        return results.toArray(new CandidateInfo[results.size()]);
    }

    public static String updateMethodPresentation(@NotNull PsiMethod method, @Nullable PsiSubstitutor substitutor, @NotNull ParameterInfoUIContext context) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "updateMethodPresentation"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "updateMethodPresentation"));
        }
        CodeInsightSettings settings = CodeInsightSettings.getInstance();
        if (!method.isValid() || substitutor != null && !substitutor.isValid()) {
            context.setUIComponentEnabled(false);
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            if (!method.isConstructor()) {
                PsiType returnType = method.getReturnType();
                if (substitutor != null) {
                    returnType = substitutor.substitute(returnType);
                }
                MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)method);
                buffer.append(returnType.getPresentableText());
                buffer.append(" ");
            }
            buffer.append(method.getName());
            buffer.append("(");
        }
        int currentParameter = context.getCurrentParameterIndex();
        PsiParameter[] parms = method.getParameterList().getParameters();
        int numParams = parms.length;
        int highlightStartOffset = -1;
        int highlightEndOffset = -1;
        if (numParams > 0) {
            for (int j = 0; j < numParams; ++j) {
                PsiParameter param = parms[j];
                int startOffset = buffer.length();
                if (param.isValid()) {
                    PsiType paramType = param.getType();
                    assert (paramType.isValid());
                    if (substitutor != null) {
                        assert (substitutor.isValid());
                        paramType = substitutor.substitute(paramType);
                    }
                    MethodParameterInfoHandler.appendModifierList(buffer, (PsiModifierListOwner)param);
                    buffer.append(paramType.getPresentableText());
                    String name = param.getName();
                    if (name != null) {
                        buffer.append(" ");
                        buffer.append(name);
                    }
                }
                int endOffset = buffer.length();
                if (j < numParams - 1) {
                    buffer.append(", ");
                }
                if (!context.isUIComponentEnabled() || j != currentParameter && (j != numParams - 1 || !param.isVarArgs() || currentParameter < numParams)) continue;
                highlightStartOffset = startOffset;
                highlightEndOffset = endOffset;
            }
        } else {
            buffer.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        if (settings.SHOW_FULL_SIGNATURES_IN_PARAMETER_INFO) {
            buffer.append(")");
        }
        return context.setupUIComponentPresentation(buffer.toString(), highlightStartOffset, highlightEndOffset, !context.isUIComponentEnabled(), method.isDeprecated(), false, context.getDefaultParameterColor());
    }

    private static void appendModifierList(@NotNull StringBuilder buffer, @NotNull PsiModifierListOwner owner) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "appendModifierList"));
        }
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "appendModifierList"));
        }
        int lastSize = buffer.length();
        HashSet shownAnnotations = ContainerUtil.newHashSet();
        for (PsiAnnotation annotation : AnnotationUtil.getAllAnnotations((PsiModifierListOwner)owner, (boolean)false, null, (!DumbService.isDumb((Project)owner.getProject()) ? 1 : 0) != 0)) {
            String referenceName;
            PsiElement resolved;
            PsiJavaCodeReferenceElement element = annotation.getNameReferenceElement();
            if (element == null || (resolved = element.resolve()) instanceof PsiClass && (!JavaDocInfoGenerator.isDocumentedAnnotationType(resolved) || AnnotationTargetUtil.findAnnotationTarget((PsiClass)((PsiClass)resolved), (PsiAnnotation.TargetType[])new PsiAnnotation.TargetType[]{PsiAnnotation.TargetType.TYPE_USE}) != null) || !shownAnnotations.add(referenceName = element.getReferenceName()) && !JavaDocInfoGenerator.isRepeatableAnnotationType(resolved)) continue;
            if (lastSize != buffer.length()) {
                buffer.append(' ');
            }
            buffer.append('@').append(referenceName);
        }
        if (lastSize != buffer.length()) {
            buffer.append(' ');
        }
    }

    public void updateUI(Object p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/codeInsight/hint/api/impls/MethodParameterInfoHandler", "updateUI"));
        }
        if (p instanceof CandidateInfo) {
            CandidateInfo info = (CandidateInfo)p;
            PsiMethod method = (PsiMethod)info.getElement();
            if (!method.isValid()) {
                context.setUIComponentEnabled(false);
                return;
            }
            MethodParameterInfoHandler.updateMethodPresentation(method, MethodParameterInfoHandler.getCandidateInfoSubstitutor(info), context);
        } else {
            MethodParameterInfoHandler.updateMethodPresentation((PsiMethod)p, null, context);
        }
    }
}

