/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiJavaToken;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class BreakStringOnLineBreaksIntentionAction
extends PsiElementBaseIntentionAction {
    public boolean isAvailable(@NotNull Project project2, Editor editor, @NotNull PsiElement element) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "isAvailable"));
        }
        if (!(element instanceof PsiJavaToken)) {
            return false;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return false;
        }
        String text = token.getText();
        if (text == null) {
            return false;
        }
        int indexOfSlashN = text.indexOf("\\n");
        if (indexOfSlashN == -1 || Comparing.equal((String)text.substring(indexOfSlashN, text.length()), (String)"\\n\"")) {
            return false;
        }
        int indexOfSlashNSlashR = text.indexOf("\\n\\r");
        return indexOfSlashNSlashR == -1 || !Comparing.equal((String)text.substring(indexOfSlashNSlashR, text.length()), (String)"\\n\\r\"");
    }

    public void invoke(@NotNull Project project2, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "invoke"));
        }
        if (!(element instanceof PsiJavaToken)) {
            return;
        }
        PsiJavaToken token = (PsiJavaToken)element;
        if (token.getTokenType() != JavaTokenType.STRING_LITERAL) {
            return;
        }
        String text = token.getText();
        if (text == null) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getElementFactory((Project)project2);
        token.replace((PsiElement)factory.createExpressionFromText(BreakStringOnLineBreaksIntentionAction.breakOnLineBreaks(text), element));
    }

    @NotNull
    private static String breakOnLineBreaks(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "breakOnLineBreaks"));
        }
        String result = StringUtil.replace((String)string, (String[])new String[]{"\\n\\r", "\\n"}, (String[])new String[]{"\\n\\r\" + \n\"", "\\n\" + \n\""});
        String redundantSuffix = " + \n\"\"";
        String string2 = result.endsWith(" + \n\"\"") ? result.substring(0, result.length() - " + \n\"\"".length()) : result;
        if (string2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "breakOnLineBreaks"));
        }
        return string2;
    }

    @NotNull
    public String getText() {
        String string = CodeInsightBundle.message((String)"intention.break.string.on.line.breaks.text", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/BreakStringOnLineBreaksIntentionAction", "getFamilyName"));
        }
        return string;
    }
}

