/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.template.TemplateLookupSelectionHandler;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class TemplateExpressionLookupElement
extends LookupElementDecorator<LookupElement> {
    private final TemplateState myState;

    public TemplateExpressionLookupElement(TemplateState state, LookupElement element, int index) {
        super(PrioritizedLookupElement.withPriority((LookupElement)element, (double)(0x7FFFFFF5 - index)));
        this.myState = state;
    }

    private static InsertionContext createInsertionContext(LookupElement item, PsiFile psiFile, List<? extends LookupElement> elements, Editor editor, char completionChar) {
        OffsetMap offsetMap = new OffsetMap(editor.getDocument());
        InsertionContext context = new InsertionContext(offsetMap, completionChar, elements.toArray(new LookupElement[elements.size()]), psiFile, editor, false);
        context.setTailOffset(editor.getCaretModel().getOffset());
        offsetMap.addOffset(CompletionInitializationContext.START_OFFSET, context.getTailOffset() - item.getLookupString().length());
        offsetMap.addOffset(CompletionInitializationContext.SELECTION_END_OFFSET, context.getTailOffset());
        offsetMap.addOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET, context.getTailOffset());
        return context;
    }

    void handleTemplateInsert(List<? extends LookupElement> elements, char completionChar) {
        final InsertionContext context = TemplateExpressionLookupElement.createInsertionContext((LookupElement)this, this.myState.getPsiFile(), elements, this.myState.getEditor(), completionChar);
        new WriteCommandAction(context.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/codeInsight/template/impl/TemplateExpressionLookupElement$1", "run"));
                }
                TemplateExpressionLookupElement.this.handleInsert(context);
            }
        }.execute();
        Disposer.dispose((Disposable)context.getOffsetMap());
    }

    public void handleInsert(InsertionContext context) {
        LookupElement item = this.getDelegate();
        Project project2 = context.getProject();
        Editor editor = context.getEditor();
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        TextRange range = this.myState.getCurrentVariableRange();
        TemplateLookupSelectionHandler handler2 = (TemplateLookupSelectionHandler)item.getUserData(TemplateLookupSelectionHandler.KEY_IN_LOOKUP_ITEM);
        if (handler2 != null && range != null) {
            handler2.itemSelected(item, context.getFile(), context.getDocument(), range.getStartOffset(), range.getEndOffset());
        } else {
            super.handleInsert(context);
        }
        if (context.getCompletionChar() == '.') {
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)".");
            AutoPopupController.getInstance(project2).autoPopupMemberLookup(editor, null);
            return;
        }
        if (!this.myState.isFinished()) {
            this.myState.calcResults(true);
        }
        this.myState.nextTab();
    }
}

