/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;

public abstract class SplitWordsMacro
extends MacroBase {
    private final char mySeparator;

    private SplitWordsMacro(String name, String description, char separator) {
        super(name, description);
        this.mySeparator = separator;
    }

    @Override
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/codeInsight/template/macro/SplitWordsMacro", "calculateResult"));
        }
        String text = SplitWordsMacro.getTextResult(params, context, true);
        if (StringUtil.isNotEmpty((String)text)) {
            return new TextResult(this.convertString(text));
        }
        return null;
    }

    @VisibleForTesting
    public String convertString(String text) {
        String[] words = NameUtil.nameToWords((String)text);
        boolean insertSeparator = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append(this.mySeparator);
                insertSeparator = false;
                continue;
            }
            if (insertSeparator) {
                buf.append(this.mySeparator);
            } else {
                insertSeparator = true;
            }
            buf.append(this.convertCase(word));
        }
        return buf.toString();
    }

    @NotNull
    protected abstract String convertCase(@NotNull String var1);

    public static class SpaceSeparated
    extends SplitWordsMacro {
        public SpaceSeparated() {
            super("spaceSeparated", "spaceSeparated(String)", ' ');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated", "convertCase"));
            }
            String string = word;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SpaceSeparated", "convertCase"));
            }
            return string;
        }
    }

    public static class LowercaseAndDash
    extends SplitWordsMacro {
        public LowercaseAndDash() {
            super("lowercaseAndDash", "lowercaseAndDash(String)", '-');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash", "convertCase"));
            }
            String string = word.toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$LowercaseAndDash", "convertCase"));
            }
            return string;
        }
    }

    public static class SnakeCaseMacro
    extends SplitWordsMacro {
        public SnakeCaseMacro() {
            super("snakeCase", "snakeCase(String)", '_');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro", "convertCase"));
            }
            String string = word.toLowerCase();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$SnakeCaseMacro", "convertCase"));
            }
            return string;
        }
    }

    public static class CapitalizeAndUnderscoreMacro
    extends SplitWordsMacro {
        public CapitalizeAndUnderscoreMacro() {
            super("capitalizeAndUnderscore", CodeInsightBundle.message((String)"macro.capitalizeAndUnderscore.string", (Object[])new Object[0]), '_');
        }

        @Override
        @NotNull
        protected String convertCase(@NotNull String word) {
            if (word == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "word", "com/intellij/codeInsight/template/macro/SplitWordsMacro$CapitalizeAndUnderscoreMacro", "convertCase"));
            }
            String string = StringUtil.toUpperCase((String)word);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SplitWordsMacro$CapitalizeAndUnderscoreMacro", "convertCase"));
            }
            return string;
        }
    }
}

