/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplateProvider;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class LanguagePostfixTemplate
extends LanguageExtension<PostfixTemplateProvider> {
    private static final Logger LOG = Logger.getInstance(LanguagePostfixTemplate.class);
    public static final LanguagePostfixTemplate LANG_EP = new LanguagePostfixTemplate();
    public static final String EP_NAME = "com.intellij.codeInsight.template.postfixTemplateProvider";

    private LanguagePostfixTemplate() {
        super(EP_NAME);
    }

    @NotNull
    protected List<PostfixTemplateProvider> buildExtensions(@NotNull String stringKey, @NotNull Language key) {
        if (stringKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringKey", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        List providers = super.buildExtensions(stringKey, (Object)key);
        LanguagePostfixTemplate.validateTemplatesForLanguage(key, providers);
        List list = providers;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/LanguagePostfixTemplate", "buildExtensions"));
        }
        return list;
    }

    private static void validateTemplatesForLanguage(Language key, List<PostfixTemplateProvider> providers) {
        HashSet templateKeys = ContainerUtil.newHashSet();
        for (PostfixTemplateProvider provider : providers) {
            for (PostfixTemplate template : provider.getTemplates()) {
                if (templateKeys.add(template.getKey())) continue;
                LOG.error("Duplicated key " + template.getKey() + " for language " + key.getID() + " provider " + provider.getClass());
            }
        }
    }
}

