/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightControlFlowUtil;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LambdaCanBeMethodReferenceInspection;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiQualifiedExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.RedundantCastUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.IntArrayList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamApiMigrationInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance((String)("#" + StreamApiMigrationInspection.class.getName()));
    public boolean REPLACE_TRIVIAL_FOREACH = false;

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Replace trivial foreach statements", (InspectionProfileEntry)this, "REPLACE_TRIVIAL_FOREACH");
    }

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.LANGUAGE_LEVEL_SPECIFIC_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("foreach loop can be collapsed with stream api" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getDisplayName"));
        }
        return "foreach loop can be collapsed with stream api";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getShortName() {
        if ("Convert2streamapi" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "getShortName"));
        }
        return "Convert2streamapi";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitForeachStatement(PsiForeachStatement statement2) {
                super.visitForeachStatement(statement2);
                if (PsiUtil.getLanguageLevel((PsiElement)statement2).isAtLeast(LanguageLevel.JDK_1_8)) {
                    PsiType iteratedValueType;
                    PsiExpression iteratedValue = statement2.getIteratedValue();
                    PsiStatement body = statement2.getBody();
                    if (iteratedValue != null && body != null && InheritanceUtil.isInheritor((PsiType)(iteratedValueType = iteratedValue.getType()), (String)"java.util.Collection")) {
                        PsiClass iteratorClass = PsiUtil.resolveClassInType((PsiType)iteratedValueType);
                        LOG.assertTrue(iteratorClass != null);
                        try {
                            ControlFlow controlFlow = ControlFlowFactory.getInstance(holder.getProject()).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance());
                            int startOffset = controlFlow.getStartOffset((PsiElement)body);
                            int endOffset = controlFlow.getEndOffset((PsiElement)body);
                            Collection<PsiStatement> exitPoints = ControlFlowUtil.findExitPointsAndStatements(controlFlow, startOffset, endOffset, new IntArrayList(), PsiContinueStatement.class, PsiBreakStatement.class, PsiReturnStatement.class, PsiThrowStatement.class);
                            if (exitPoints.isEmpty()) {
                                List<PsiVariable> usedVariables = ControlFlowUtil.getUsedVariables(controlFlow, startOffset, endOffset);
                                for (PsiVariable variable : usedVariables) {
                                    if (HighlightControlFlowUtil.isEffectivelyFinal(variable, (PsiElement)body, null)) continue;
                                    return;
                                }
                                if (ExceptionUtil.getThrownCheckedExceptions(new PsiElement[]{body}).isEmpty()) {
                                    if (!(iteratedValueType instanceof PsiClassType && ((PsiClassType)iteratedValueType).isRaw() || !StreamApiMigrationInspection.isCollectCall(body, statement2.getIterationParameter()))) {
                                        boolean addAll = StreamApiMigrationInspection.isAddAllCall(statement2, body);
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with " + (addAll ? "addAll call" : "collect call"), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new ReplaceWithCollectCallFix("Replace with " + (addAll ? "addAll" : "collect"))});
                                    } else if (StreamApiMigrationInspection.this.REPLACE_TRIVIAL_FOREACH || !StreamApiMigrationInspection.isTrivial(body, statement2.getIterationParameter())) {
                                        ArrayList<ReplaceWithForeachCallFix> fixes = new ArrayList<ReplaceWithForeachCallFix>();
                                        fixes.add(new ReplaceWithForeachCallFix("forEach"));
                                        if (StreamApiMigrationInspection.extractIfStatement(body) != null) {
                                            fixes.add(new ReplaceWithForeachCallFix("forEachOrdered"));
                                        }
                                        holder.registerProblem((PsiElement)iteratedValue, "Can be replaced with foreach call", ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes.toArray(new LocalQuickFix[fixes.size()]));
                                    }
                                }
                            }
                        }
                        catch (AnalysisCanceledException analysisCanceledException) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static boolean isAddAllCall(PsiForeachStatement statement2, PsiStatement body) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement == null) {
            PsiParameter parameter = statement2.getIterationParameter();
            PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, null);
            LOG.assertTrue(methodCallExpression != null);
            return StreamApiMigrationInspection.isIdentityMapping(parameter, methodCallExpression.getArgumentList().getExpressions()[0]);
        }
        return false;
    }

    private static boolean isCollectCall(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
        if (methodCallExpression != null) {
            PsiClass enclosingClass;
            PsiElement resolve;
            PsiReferenceExpression methodExpression = methodCallExpression.getMethodExpression();
            PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
            PsiClass qualifierClass = null;
            if (qualifierExpression instanceof PsiReferenceExpression) {
                if (ReferencesSearch.search((PsiElement)parameter, (SearchScope)new LocalSearchScope((PsiElement)qualifierExpression)).findFirst() != null) {
                    return false;
                }
                resolve = ((PsiReferenceExpression)qualifierExpression).resolve();
                if (resolve instanceof PsiVariable && ReferencesSearch.search((PsiElement)resolve, (SearchScope)new LocalSearchScope((PsiElement)methodCallExpression.getArgumentList())).findFirst() != null) {
                    return false;
                }
                qualifierClass = PsiUtil.resolveClassInType((PsiType)qualifierExpression.getType());
            } else if (qualifierExpression == null && PsiUtil.getEnclosingStaticElement((PsiElement)body, (PsiClass)(enclosingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)body, PsiClass.class))) == null) {
                qualifierClass = enclosingClass;
            }
            if (qualifierClass != null && InheritanceUtil.isInheritor(qualifierClass, (boolean)false, (String)"java.util.Collection")) {
                PsiExpression[] args;
                while (ifStatement != null && PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)ifStatement, (boolean)false)) {
                    PsiExpression condition = ifStatement.getCondition();
                    if (condition != null && StreamApiMigrationInspection.isConditionDependsOnUpdatedCollections(condition, qualifierExpression)) {
                        return false;
                    }
                    ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
                }
                resolve = methodExpression.resolve();
                if (resolve instanceof PsiMethod && "add".equals(((PsiMethod)resolve).getName()) && ((PsiMethod)resolve).getParameterList().getParametersCount() == 1 && (args = methodCallExpression.getArgumentList().getExpressions()).length == 1) {
                    if (args[0] instanceof PsiCallExpression) {
                        PsiMethod method = ((PsiCallExpression)args[0]).resolveMethod();
                        return method != null && !method.hasTypeParameters() && !StreamApiMigrationInspection.isThrowsCompatible(method);
                    }
                    return true;
                }
            }
        }
        return false;
    }

    private static boolean isConditionDependsOnUpdatedCollections(PsiExpression condition, PsiExpression qualifierExpression) {
        PsiElement collection;
        PsiElement psiElement = collection = qualifierExpression instanceof PsiReferenceExpression ? ((PsiReferenceExpression)qualifierExpression).resolve() : null;
        if (collection != null) {
            return ReferencesSearch.search((PsiElement)collection, (SearchScope)new LocalSearchScope((PsiElement)condition)).findFirst() != null;
        }
        final boolean[] dependsOnCollection = new boolean[]{false};
        condition.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression expression) {
                super.visitMethodCallExpression(expression);
                PsiExpression callQualifier = expression.getMethodExpression().getQualifierExpression();
                if (callQualifier == null || callQualifier instanceof PsiThisExpression && ((PsiThisExpression)callQualifier).getQualifier() == null || callQualifier instanceof PsiSuperExpression && ((PsiSuperExpression)callQualifier).getQualifier() == null) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                super.visitThisExpression(expression);
                if (expression.getQualifier() == null && expression.getParent() instanceof PsiExpressionList) {
                    dependsOnCollection[0] = true;
                }
            }

            public void visitClass(PsiClass aClass) {
            }

            public void visitLambdaExpression(PsiLambdaExpression expression) {
            }
        });
        return dependsOnCollection[0];
    }

    private static boolean isTrivial(PsiStatement body, PsiParameter parameter) {
        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
        if (ifStatement != null) {
            return false;
        }
        PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)(body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body), new PsiParameter[]{parameter}, (PsiType)StreamApiMigrationInspection.createDefaultConsumerType(parameter.getProject(), parameter));
        if (callExpression == null) {
            return true;
        }
        PsiMethod method = callExpression.resolveMethod();
        return method != null && StreamApiMigrationInspection.isThrowsCompatible(method);
    }

    private static boolean isThrowsCompatible(PsiMethod method) {
        return ContainerUtil.find((Object[])method.getThrowsList().getReferencedTypes(), (Condition)new Condition<PsiClassType>(){

            public boolean value(PsiClassType type) {
                return !ExceptionUtil.isUncheckedException(type);
            }
        }) != null;
    }

    private static boolean isIdentityMapping(PsiParameter parameter, PsiExpression mapperCall) {
        return mapperCall instanceof PsiReferenceExpression && ((PsiReferenceExpression)mapperCall).resolve() == parameter;
    }

    private static PsiClassType createDefaultConsumerType(Project project2, PsiParameter parameter) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
        PsiClass consumerClass = psiFacade.findClass("java.util.function.Consumer", GlobalSearchScope.allScope((Project)project2));
        return consumerClass != null ? psiFacade.getElementFactory().createType(consumerClass, parameter.getType()) : null;
    }

    private static void simplifyRedundantCast(PsiElement result) {
        PsiElement parent;
        PsiMethodReferenceExpression methodReferenceExpression = (PsiMethodReferenceExpression)PsiTreeUtil.findChildOfType((PsiElement)result, PsiMethodReferenceExpression.class);
        if (methodReferenceExpression != null && (parent = methodReferenceExpression.getParent()) instanceof PsiTypeCastExpression && RedundantCastUtil.isCastRedundant((PsiTypeCastExpression)((PsiTypeCastExpression)parent))) {
            PsiExpression operand = ((PsiTypeCastExpression)parent).getOperand();
            LOG.assertTrue(operand != null);
            parent.replace((PsiElement)operand);
        }
    }

    private static void restoreComments(PsiForeachStatement foreachStatement, PsiStatement body) {
        PsiElement parent = foreachStatement.getParent();
        for (PsiElement comment : PsiTreeUtil.findChildrenOfType((PsiElement)body, PsiComment.class)) {
            parent.addBefore(comment, (PsiElement)foreachStatement);
        }
    }

    private static String createFiltersChainText(PsiStatement body, PsiParameter parameter, PsiIfStatement ifStatement) {
        ArrayList<String> filters = new ArrayList<String>();
        while (ifStatement != null && PsiTreeUtil.isAncestor((PsiElement)body, (PsiElement)ifStatement, (boolean)false)) {
            PsiExpression condition = ifStatement.getCondition();
            if (condition != null) {
                filters.add(".filter(" + parameter.getName() + " -> " + condition.getText() + ")");
            }
            ifStatement = (PsiIfStatement)PsiTreeUtil.getParentOfType((PsiElement)ifStatement, PsiIfStatement.class);
        }
        Collections.reverse(filters);
        return StringUtil.join(filters, (String)"");
    }

    private static String getIteratedValueText(PsiExpression iteratedValue) {
        return iteratedValue instanceof PsiCallExpression || iteratedValue instanceof PsiReferenceExpression || iteratedValue instanceof PsiQualifiedExpression || iteratedValue instanceof PsiParenthesizedExpression ? iteratedValue.getText() : "(" + iteratedValue.getText() + ")";
    }

    private static PsiIfStatement extractIfStatement(PsiStatement body) {
        PsiStatement thenBranch;
        PsiStatement[] statements;
        PsiIfStatement ifStmt = null;
        if (body instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)body;
        } else if (body instanceof PsiBlockStatement && (statements = ((PsiBlockStatement)body).getCodeBlock().getStatements()).length == 1 && statements[0] instanceof PsiIfStatement) {
            ifStmt = (PsiIfStatement)statements[0];
        }
        if (ifStmt != null && ifStmt.getElseBranch() == null && ifStmt.getCondition() != null && (thenBranch = ifStmt.getThenBranch()) != null) {
            PsiIfStatement deeperThen = StreamApiMigrationInspection.extractIfStatement(thenBranch);
            return deeperThen != null ? deeperThen : ifStmt;
        }
        return null;
    }

    private static PsiMethodCallExpression extractAddCall(PsiStatement body, PsiIfStatement ifStatement) {
        PsiExpression expression;
        if (ifStatement != null) {
            PsiStatement thenBranch = ifStatement.getThenBranch();
            return StreamApiMigrationInspection.extractAddCall(thenBranch, null);
        }
        PsiExpressionStatement stmt = null;
        if (body instanceof PsiBlockStatement) {
            PsiStatement[] statements = ((PsiBlockStatement)body).getCodeBlock().getStatements();
            if (statements.length == 1 && statements[0] instanceof PsiExpressionStatement) {
                stmt = (PsiExpressionStatement)statements[0];
            }
        } else if (body instanceof PsiExpressionStatement) {
            stmt = (PsiExpressionStatement)body;
        }
        if (stmt != null && (expression = stmt.getExpression()) instanceof PsiMethodCallExpression) {
            return (PsiMethodCallExpression)expression;
        }
        return null;
    }

    private static class ReplaceWithCollectCallFix
    implements LocalQuickFix {
        private final String myName;

        public ReplaceWithCollectCallFix(String name) {
            this.myName = name;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.myName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "getFamilyName"));
            }
            return string;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)foreachStatement)) {
                    return;
                }
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    PsiExpression qualifierExpression;
                    PsiElement result;
                    StringBuilder builder;
                    block10: {
                        PsiParameter parameter = foreachStatement.getIterationParameter();
                        PsiIfStatement ifStatement = StreamApiMigrationInspection.extractIfStatement(body);
                        PsiMethodCallExpression methodCallExpression = StreamApiMigrationInspection.extractAddCall(body, ifStatement);
                        if (methodCallExpression == null) {
                            return;
                        }
                        if (StreamApiMigrationInspection.isAddAllCall(foreachStatement, body)) {
                            StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                            PsiExpression qualifierExpression2 = methodCallExpression.getMethodExpression().getQualifierExpression();
                            String qualifierText = qualifierExpression2 != null ? qualifierExpression2.getText() : "";
                            String callText = StringUtil.getQualifiedName((String)qualifierText, (String)("addAll(" + StreamApiMigrationInspection.getIteratedValueText(iteratedValue) + ");"));
                            PsiElement result2 = foreachStatement.replace((PsiElement)elementFactory.createStatementFromText(callText, (PsiElement)foreachStatement));
                            ReplaceWithCollectCallFix.reformatWhenNeeded(project2, result2);
                            return;
                        }
                        builder = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue) + ".stream()");
                        builder.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStatement));
                        builder.append(ReplaceWithCollectCallFix.createMapperFunctionalExpressionText(project2, parameter, methodCallExpression.getArgumentList().getExpressions()[0]));
                        builder.append(".collect(java.util.stream.Collectors.");
                        result = null;
                        try {
                            PsiExpressionList argumentList;
                            PsiExpression initializer;
                            PsiElement resolve;
                            qualifierExpression = methodCallExpression.getMethodExpression().getQualifierExpression();
                            if (!(qualifierExpression instanceof PsiReferenceExpression) || !((resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiVariable) || !(resolve instanceof PsiLocalVariable) || !foreachStatement.equals(PsiTreeUtil.skipSiblingsForward((PsiElement)resolve.getParent(), (Class[])new Class[]{PsiWhiteSpace.class})) || !((initializer = ((PsiVariable)resolve).getInitializer()) instanceof PsiNewExpression) || (argumentList = ((PsiNewExpression)initializer).getArgumentList()) == null || argumentList.getExpressions().length != 0) break block10;
                            StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                            String callText = builder.toString() + ReplaceWithCollectCallFix.createInitializerReplacementText(((PsiVariable)resolve).getType(), initializer) + ")";
                            result = initializer.replace((PsiElement)elementFactory.createExpressionFromText(callText, null));
                            StreamApiMigrationInspection.simplifyRedundantCast(result);
                            foreachStatement.delete();
                        }
                        catch (Throwable throwable) {
                            ReplaceWithCollectCallFix.reformatWhenNeeded(project2, result);
                            throw throwable;
                        }
                        ReplaceWithCollectCallFix.reformatWhenNeeded(project2, result);
                        return;
                    }
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    String qualifierText = qualifierExpression != null ? qualifierExpression.getText() : "";
                    String callText = StringUtil.getQualifiedName((String)qualifierText, (String)("addAll(" + builder.toString() + "toList()));"));
                    result = foreachStatement.replace((PsiElement)elementFactory.createStatementFromText(callText, (PsiElement)foreachStatement));
                    StreamApiMigrationInspection.simplifyRedundantCast(result);
                    ReplaceWithCollectCallFix.reformatWhenNeeded(project2, result);
                }
            }
        }

        private static void reformatWhenNeeded(@NotNull Project project2, PsiElement result) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithCollectCallFix", "reformatWhenNeeded"));
            }
            if (result != null) {
                CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences(result));
            }
        }

        private static String createInitializerReplacementText(PsiType varType, PsiExpression initializer) {
            PsiClassType rawVarType;
            PsiType initializerType = initializer.getType();
            PsiClassType rawType = initializerType instanceof PsiClassType ? ((PsiClassType)initializerType).rawType() : null;
            PsiClassType psiClassType = rawVarType = varType instanceof PsiClassType ? ((PsiClassType)varType).rawType() : null;
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.ArrayList") && rawVarType.equalsToText("java.util.List")) {
                return "toList()";
            }
            if (rawType != null && rawVarType != null && rawType.equalsToText("java.util.HashSet") && rawVarType.equalsToText("java.util.Set")) {
                return "toSet()";
            }
            if (rawType != null) {
                return "toCollection(" + rawType.getClassName() + "::new)";
            }
            return "toCollection(() -> " + initializer.getText() + ")";
        }

        private static String createMapperFunctionalExpressionText(Project project2, PsiParameter parameter, PsiExpression expression) {
            String iteration = "";
            if (!StreamApiMigrationInspection.isIdentityMapping(parameter, expression)) {
                iteration = iteration + ".map(";
                JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)project2);
                PsiClass functionClass = psiFacade.findClass("java.util.function.Function", GlobalSearchScope.allScope((Project)project2));
                PsiType[] paramTypes = new PsiType[]{parameter.getType(), expression.getType()};
                for (int i = 0; i < paramTypes.length; ++i) {
                    if (!(paramTypes[i] instanceof PsiPrimitiveType)) continue;
                    paramTypes[i] = ((PsiPrimitiveType)paramTypes[i]).getBoxedType((PsiElement)expression);
                }
                PsiClassType functionalInterfaceType = functionClass != null ? psiFacade.getElementFactory().createType(functionClass, paramTypes) : null;
                PsiCallExpression toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)expression, new PsiParameter[]{parameter}, (PsiType)functionalInterfaceType);
                String methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)toConvertCall, (PsiType)functionalInterfaceType, new PsiParameter[]{parameter});
                if (methodReferenceText != null) {
                    LOG.assertTrue(functionalInterfaceType != null);
                    iteration = iteration + "(" + functionalInterfaceType.getCanonicalText() + ")" + methodReferenceText;
                } else {
                    iteration = iteration + parameter.getName() + " -> " + expression.getText();
                }
                iteration = iteration + ")";
            }
            return iteration;
        }
    }

    private static class ReplaceWithForeachCallFix
    implements LocalQuickFix {
        private final String myForEachMethodName;

        private ReplaceWithForeachCallFix(String forEachMethodName) {
            this.myForEachMethodName = forEachMethodName;
        }

        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = "Replace with " + this.myForEachMethodName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/StreamApiMigrationInspection$ReplaceWithForeachCallFix", "applyFix"));
            }
            PsiForeachStatement foreachStatement = (PsiForeachStatement)PsiTreeUtil.getParentOfType((PsiElement)descriptor.getPsiElement(), PsiForeachStatement.class);
            if (foreachStatement != null) {
                if (!FileModificationService.getInstance().preparePsiElementForWrite((PsiElement)foreachStatement)) {
                    return;
                }
                PsiStatement body = foreachStatement.getBody();
                PsiExpression iteratedValue = foreachStatement.getIteratedValue();
                if (body != null && iteratedValue != null) {
                    StreamApiMigrationInspection.restoreComments(foreachStatement, body);
                    PsiParameter parameter = foreachStatement.getIterationParameter();
                    PsiIfStatement ifStmt = StreamApiMigrationInspection.extractIfStatement(body);
                    StringBuilder buffer = new StringBuilder(StreamApiMigrationInspection.getIteratedValueText(iteratedValue));
                    if (ifStmt != null) {
                        PsiStatement thenBranch = ifStmt.getThenBranch();
                        LOG.assertTrue(thenBranch != null);
                        buffer.append(".stream()");
                        buffer.append(StreamApiMigrationInspection.createFiltersChainText(body, parameter, ifStmt));
                        body = thenBranch;
                    }
                    buffer.append("." + this.myForEachMethodName + "(");
                    String functionalExpressionText = ReplaceWithForeachCallFix.createForEachFunctionalExpressionText(project2, body, parameter);
                    PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project2);
                    PsiExpressionStatement callStatement = (PsiExpressionStatement)elementFactory.createStatementFromText(buffer.toString() + functionalExpressionText + ");", (PsiElement)foreachStatement);
                    callStatement = (PsiExpressionStatement)foreachStatement.replace((PsiElement)callStatement);
                    PsiExpressionList argumentList = ((PsiCallExpression)callStatement.getExpression()).getArgumentList();
                    LOG.assertTrue(argumentList != null, (Object)callStatement.getText());
                    PsiExpression[] expressions = argumentList.getExpressions();
                    LOG.assertTrue(expressions.length == 1);
                    if (expressions[0] instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)expressions[0]).getFunctionalInterfaceType() == null) {
                        callStatement = (PsiExpressionStatement)callStatement.replace((PsiElement)elementFactory.createStatementFromText(buffer.toString() + "(" + parameter.getText() + ") -> " + ReplaceWithForeachCallFix.wrapInBlock(body) + ");", (PsiElement)callStatement));
                    }
                    StreamApiMigrationInspection.simplifyRedundantCast((PsiElement)callStatement);
                    CodeStyleManager.getInstance((Project)project2).reformat(JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)callStatement));
                }
            }
        }

        private static String createForEachFunctionalExpressionText(Project project2, PsiStatement body, PsiParameter parameter) {
            PsiClassType functionalType;
            PsiParameter[] parameters;
            PsiStatement bodyBlock;
            PsiCallExpression toConvertCall;
            String methodReferenceText;
            PsiCallExpression callExpression = LambdaCanBeMethodReferenceInspection.extractMethodCallFromBlock((PsiElement)body);
            if (callExpression != null && (methodReferenceText = LambdaCanBeMethodReferenceInspection.createMethodReferenceText((PsiElement)(toConvertCall = LambdaCanBeMethodReferenceInspection.canBeMethodReferenceProblem((PsiElement)(bodyBlock = body instanceof PsiBlockStatement ? ((PsiBlockStatement)body).getCodeBlock() : body), parameters = new PsiParameter[]{parameter}, (PsiType)(functionalType = StreamApiMigrationInspection.createDefaultConsumerType(project2, parameter)))), (PsiType)functionalType, parameters)) != null) {
                return methodReferenceText;
            }
            return parameter.getName() + " -> " + ReplaceWithForeachCallFix.wrapInBlock(body);
        }

        private static String wrapInBlock(PsiStatement body) {
            if (body instanceof PsiExpressionStatement) {
                return ((PsiExpressionStatement)body).getExpression().getText();
            }
            String bodyText = body.getText();
            if (!(body instanceof PsiBlockStatement)) {
                return "{" + bodyText + "}";
            }
            return bodyText;
        }
    }
}

