/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis;

import com.intellij.codeInspection.bytecodeAnalysis.ELattice;
import com.intellij.codeInspection.bytecodeAnalysis.HComponent;
import com.intellij.codeInspection.bytecodeAnalysis.HFinal;
import com.intellij.codeInspection.bytecodeAnalysis.HKey;
import com.intellij.codeInspection.bytecodeAnalysis.HPending;
import com.intellij.codeInspection.bytecodeAnalysis.HResult;
import com.intellij.codeInspection.bytecodeAnalysis.Value;
import com.intellij.util.ArrayFactory;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;

class HResultUtil {
    private static final HKey[] EMPTY_PRODUCT = new HKey[0];
    private static final ArrayFactory<HComponent> HCOMPONENT_ARRAY_FACTORY = new ArrayFactory<HComponent>(){

        @NotNull
        public HComponent[] create(int count) {
            HComponent[] hComponentArray = new HComponent[count];
            if (hComponentArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/HResultUtil$1", "create"));
            }
            return hComponentArray;
        }
    };
    private final ELattice<Value> lattice;
    final Value top;

    HResultUtil(ELattice<Value> lattice) {
        this.lattice = lattice;
        this.top = (Value)((Object)lattice.top);
    }

    HResult join(HResult r1, HResult r2) {
        if (r1 instanceof HFinal && ((HFinal)r1).value == this.top) {
            return r1;
        }
        if (r2 instanceof HFinal && ((HFinal)r2).value == this.top) {
            return r2;
        }
        if (r1 instanceof HFinal && r2 instanceof HFinal) {
            return new HFinal(this.lattice.join(((HFinal)r1).value, ((HFinal)r2).value));
        }
        if (r1 instanceof HFinal && r2 instanceof HPending) {
            HFinal f1 = (HFinal)r1;
            HPending pending = (HPending)r2;
            HComponent[] delta = new HComponent[pending.delta.length + 1];
            delta[0] = new HComponent(f1.value, EMPTY_PRODUCT);
            System.arraycopy(pending.delta, 0, delta, 1, pending.delta.length);
            return new HPending(delta);
        }
        if (r1 instanceof HPending && r2 instanceof HFinal) {
            HFinal f2 = (HFinal)r2;
            HPending pending = (HPending)r1;
            HComponent[] delta = new HComponent[pending.delta.length + 1];
            delta[0] = new HComponent(f2.value, EMPTY_PRODUCT);
            System.arraycopy(pending.delta, 0, delta, 1, pending.delta.length);
            return new HPending(delta);
        }
        HPending pending1 = (HPending)r1;
        HPending pending2 = (HPending)r2;
        return new HPending((HComponent[])ArrayUtil.mergeArrays((Object[])pending1.delta, (Object[])pending2.delta, HCOMPONENT_ARRAY_FACTORY));
    }
}

