/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldAccessNotGuardedInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unguarded field access" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getDisplayName"));
        }
        return "Unguarded field access";
    }

    @NotNull
    public String getShortName() {
        if ("FieldAccessNotGuarded" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "getShortName"));
        }
        return "FieldAccessNotGuarded";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/FieldAccessNotGuardedInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiMethodCallExpression psiExpression) {
        PsiReferenceExpression methodExpression = psiExpression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            PsiElement resolve;
            if (FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, qualifierExpression)) {
                return true;
            }
            if (qualifierExpression instanceof PsiReferenceExpression && (resolve = ((PsiReferenceExpression)qualifierExpression).resolve()) instanceof PsiField && ((PsiField)resolve).hasModifierProperty("final")) {
                PsiExpression initializer = ((PsiField)resolve).getInitializer();
                return initializer != null && FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, methodExpression, initializer);
            }
        }
        return false;
    }

    private static boolean isCallOnGuard(String guard, String lockMethodStart, PsiReferenceExpression methodExpression, PsiExpression qualifier) {
        String methodName;
        PsiElement resolve;
        String qualifierText = qualifier.getText();
        return (qualifierText.startsWith(guard + ".") || qualifierText.equals(guard)) && (resolve = methodExpression.resolve()) instanceof PsiMethod && (methodName = ((PsiMethod)resolve).getName()).startsWith(lockMethodStart);
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            PsiSynchronizedStatement syncStatement;
            PsiElement referent = expression.resolve();
            if (!(referent instanceof PsiField)) {
                return;
            }
            PsiField field = (PsiField)referent;
            String guard = JCiPUtil.findGuardForMember((PsiMember)field);
            if (guard == null) {
                return;
            }
            PsiMethod containingMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (containingMethod != null && JCiPUtil.isGuardedBy((PsiMember)containingMethod, guard)) {
                return;
            }
            if (containingMethod != null && containingMethod.isConstructor()) {
                return;
            }
            if ("this".equals(guard) && containingMethod != null && containingMethod.hasModifierProperty("synchronized")) {
                return;
            }
            if (Visitor.findLockTryStatement(expression, guard) != null) {
                for (PsiReferenceExpression lockExpr = expression; lockExpr != null; lockExpr = lockExpr.getParent()) {
                    for (PsiReferenceExpression child = lockExpr; child != null; child = child.getPrevSibling()) {
                        if (Visitor.isLockGuardStatement(guard, (PsiElement)child, "lock")) {
                            return;
                        }
                        PsiElement childParent = child.getParent();
                        if (!(child instanceof PsiMethodCallExpression) || !FieldAccessNotGuardedInspection.isCallOnGuard(guard, "tryLock", (PsiMethodCallExpression)child) || !(childParent instanceof PsiIfStatement) || ((PsiIfStatement)childParent).getCondition() != child) continue;
                        return;
                    }
                }
            }
            PsiReferenceExpression check = expression;
            while ((syncStatement = (PsiSynchronizedStatement)PsiTreeUtil.getParentOfType((PsiElement)check, PsiSynchronizedStatement.class)) != null) {
                PsiExpression lockExpression = syncStatement.getLockExpression();
                if (lockExpression != null && lockExpression.getText().equals(guard)) {
                    return;
                }
                check = syncStatement;
            }
            this.myHolder.registerProblem((PsiElement)expression, "Access to field <code>#ref</code> outside of declared guards #loc", new LocalQuickFix[0]);
        }

        @Nullable
        private static PsiTryStatement findLockTryStatement(PsiReferenceExpression expression, String guard) {
            PsiTryStatement tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiTryStatement.class);
            while (tryStatement != null) {
                PsiCodeBlock finallyBlock = tryStatement.getFinallyBlock();
                if (finallyBlock != null) {
                    for (PsiStatement psiStatement : finallyBlock.getStatements()) {
                        if (!Visitor.isLockGuardStatement(guard, (PsiElement)psiStatement, "unlock")) continue;
                        return tryStatement;
                    }
                }
                tryStatement = (PsiTryStatement)PsiTreeUtil.getParentOfType((PsiElement)tryStatement, PsiTryStatement.class);
            }
            return null;
        }

        private static boolean isLockGuardStatement(String guard, PsiElement element, String lockMethodStart) {
            PsiExpression psiExpression;
            if (element instanceof PsiExpressionStatement && (psiExpression = ((PsiExpressionStatement)element).getExpression()) instanceof PsiMethodCallExpression) {
                return FieldAccessNotGuardedInspection.isCallOnGuard(guard, lockMethodStart, (PsiMethodCallExpression)psiExpression);
            }
            return false;
        }
    }
}

