/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInsight.CodeInsightUtil;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.defaultFileTemplateUsage.DefaultFileTemplateUsageInspection;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TIntObjectHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class FileHeaderChecker {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker");

    static ProblemDescriptor checkFileHeader(@NotNull PsiFile file2, @NotNull InspectionManager manager, boolean onTheFly) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "checkFileHeader"));
        }
        TIntObjectHashMap offsetToProperty = new TIntObjectHashMap();
        FileTemplate defaultTemplate = FileTemplateManager.getInstance(file2.getProject()).getDefaultTemplate("File Header");
        Pattern pattern = FileHeaderChecker.getTemplatePattern(defaultTemplate, file2.getProject(), (TIntObjectHashMap<String>)offsetToProperty);
        Matcher matcher = pattern.matcher(file2.getViewProvider().getContents());
        if (!matcher.matches()) {
            return null;
        }
        PsiComment element = (PsiComment)PsiTreeUtil.findElementOfClassAtRange((PsiFile)file2, (int)matcher.start(1), (int)matcher.end(1), PsiComment.class);
        if (element == null) {
            return null;
        }
        LocalQuickFix[] fixes = FileHeaderChecker.createQuickFix(matcher, (TIntObjectHashMap<String>)offsetToProperty, file2.getProject());
        String description = InspectionsBundle.message((String)"default.file.template.description", (Object[])new Object[0]);
        return manager.createProblemDescriptor((PsiElement)element, description, onTheFly, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public static Pattern getTemplatePattern(@NotNull FileTemplate template, @NotNull Project project2, @NotNull TIntObjectHashMap<String> offsetToProperty) {
        if (template == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "template", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        if (offsetToProperty == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "offsetToProperty", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker", "getTemplatePattern"));
        }
        String templateText = template.getText().trim();
        String regex = FileHeaderChecker.templateToRegex(templateText, offsetToProperty, project2);
        regex = StringUtil.replace((String)regex, (String)"with", (String)"(?:with|by)");
        regex = ".*(" + regex + ").*";
        return Pattern.compile(regex, 32);
    }

    private static Properties computeProperties(Matcher matcher, TIntObjectHashMap<String> offsetToProperty, Project project2) {
        Properties properties = new Properties(FileTemplateManager.getInstance(project2).getDefaultProperties());
        int[] offsets = offsetToProperty.keys();
        Arrays.sort(offsets);
        for (int i = 0; i < offsets.length; ++i) {
            int offset = offsets[i];
            String propName = (String)offsetToProperty.get(offset);
            int groupNum = i + 2;
            String propValue = matcher.group(groupNum);
            properties.setProperty(propName, propValue);
        }
        return properties;
    }

    private static LocalQuickFix[] createQuickFix(final Matcher matcher, final TIntObjectHashMap<String> offsetToProperty, Project project2) {
        LocalQuickFix[] localQuickFixArray;
        final FileTemplate template = FileTemplateManager.getInstance(project2).getPattern("File Header");
        ReplaceWithFileTemplateFix replaceTemplateFix = new ReplaceWithFileTemplateFix(){

            public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
                String newText;
                if (project2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/defaultFileTemplateUsage/FileHeaderChecker$1", "applyFix"));
                }
                PsiElement element = descriptor.getPsiElement();
                if (element == null || !element.isValid()) {
                    return;
                }
                if (!CodeInsightUtil.preparePsiElementsForWrite(element)) {
                    return;
                }
                try {
                    newText = template.getText(FileHeaderChecker.computeProperties(matcher, (TIntObjectHashMap<String>)offsetToProperty, project2)).trim();
                }
                catch (IOException e) {
                    LOG.error((Throwable)e);
                    return;
                }
                if (!newText.isEmpty()) {
                    PsiComment newComment = JavaPsiFacade.getElementFactory((Project)project2).createCommentFromText(newText, null);
                    element.replace((PsiElement)newComment);
                } else {
                    element.delete();
                }
            }
        };
        LocalQuickFix editFileTemplateFix = DefaultFileTemplateUsageInspection.createEditFileTemplateFix(template, replaceTemplateFix);
        if (template.isDefault()) {
            LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[1];
            localQuickFixArray = localQuickFixArray2;
            localQuickFixArray2[0] = editFileTemplateFix;
        } else {
            LocalQuickFix[] localQuickFixArray3 = new LocalQuickFix[2];
            localQuickFixArray3[0] = replaceTemplateFix;
            localQuickFixArray = localQuickFixArray3;
            localQuickFixArray3[1] = editFileTemplateFix;
        }
        return localQuickFixArray;
    }

    private static String templateToRegex(String text, TIntObjectHashMap<String> offsetToProperty, Project project2) {
        ArrayList properties = ContainerUtil.newArrayList(FileTemplateManager.getInstance(project2).getDefaultProperties().keySet());
        properties.add("PACKAGE_NAME");
        String regex = FileHeaderChecker.escapeRegexChars(text);
        int groupNumber = 1;
        for (Object property : properties) {
            String name = property.toString();
            String escaped = FileHeaderChecker.escapeRegexChars("${" + name + "}");
            boolean first = true;
            int i = regex.indexOf(escaped);
            while (i != -1 && i < regex.length()) {
                int[] offs;
                String replacement = first ? "([^\\n]*)" : "\\" + groupNumber;
                int delta = escaped.length() - replacement.length();
                for (int off : offs = offsetToProperty.keys()) {
                    if (off <= i) continue;
                    String prop = (String)offsetToProperty.remove(off);
                    offsetToProperty.put(off - delta, (Object)prop);
                }
                offsetToProperty.put(i, (Object)name);
                regex = regex.substring(0, i) + replacement + regex.substring(i + escaped.length());
                if (first) {
                    ++groupNumber;
                    first = false;
                }
                i = regex.indexOf(escaped, i + 1);
            }
        }
        return regex;
    }

    private static String escapeRegexChars(String regex) {
        regex = StringUtil.replace((String)regex, (String)"|", (String)"\\|");
        regex = StringUtil.replace((String)regex, (String)".", (String)"\\.");
        regex = StringUtil.replace((String)regex, (String)"*", (String)"\\*");
        regex = StringUtil.replace((String)regex, (String)"+", (String)"\\+");
        regex = StringUtil.replace((String)regex, (String)"?", (String)"\\?");
        regex = StringUtil.replace((String)regex, (String)"$", (String)"\\$");
        regex = StringUtil.replace((String)regex, (String)"(", (String)"\\(");
        regex = StringUtil.replace((String)regex, (String)")", (String)"\\)");
        regex = StringUtil.replace((String)regex, (String)"[", (String)"\\[");
        regex = StringUtil.replace((String)regex, (String)"]", (String)"\\]");
        regex = StringUtil.replace((String)regex, (String)"{", (String)"\\{");
        regex = StringUtil.replace((String)regex, (String)"}", (String)"\\}");
        return regex;
    }
}

