/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.compiler.actions.GenerateAntBuildAction;
import com.intellij.compiler.ant.GenerateAntMain;
import com.intellij.compiler.ant.GenerationOptionsImpl;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import javax.swing.SwingUtilities;

public class GenerateAntApplication {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionApplication");
    public String myProjectPath = null;
    public String myOutPath = null;
    private Project myProject;
    private int myVerboseLevel = 0;

    public void startup() {
        if (this.myProjectPath == null || this.myOutPath == null) {
            GenerateAntMain.printHelp();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ApplicationEx application = ApplicationManagerEx.getApplicationEx();
                try {
                    GenerateAntApplication.this.logMessage(0, "Starting app... ");
                    application.doNotSave();
                    application.load();
                    GenerateAntApplication.this.logMessageLn(0, "done");
                    GenerateAntApplication.this.run();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
                finally {
                    application.exit(true, true);
                }
            }
        });
    }

    public void run() {
        try {
            this.myProjectPath = this.myProjectPath.replace(File.separatorChar, '/');
            VirtualFile vfsProject = LocalFileSystem.getInstance().findFileByPath(this.myProjectPath);
            if (vfsProject == null) {
                this.logError(InspectionsBundle.message((String)"inspection.application.file.cannot.be.found", (Object[])new Object[]{this.myProjectPath}));
                GenerateAntMain.printHelp();
            }
            this.logMessage(0, "Loading project...");
            this.myProject = ProjectManagerEx.getInstanceEx().loadProject(this.myProjectPath);
            this.logMessageLn(0, " done");
            GenerateAntBuildAction.generateSingleFileBuild(this.myProject, new GenerationOptionsImpl(this.myProject, true, true, false, false, new String[0]), new File("/Users/max/build/build.xml"), new File("/Users/max/build/build.properties"));
            this.logMessage(0, "Hello!");
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            GenerateAntMain.printHelp();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
            System.exit(1);
        }
    }

    public void setVerboseLevel(int verboseLevel) {
        this.myVerboseLevel = verboseLevel;
    }

    private void logMessage(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.print(message);
        }
    }

    private void logError(String message) {
        System.err.println(message);
    }

    private void logMessageLn(int minVerboseLevel, String message) {
        if (this.myVerboseLevel >= minVerboseLevel) {
            System.out.println(message);
        }
    }
}

