/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.impl.EventQueueClosedException;
import com.intellij.openapi.diagnostic.Logger;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class EventQueue<E> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.impl.EventQueue");
    private final LinkedList[] myEvents;
    private final ReentrantLock myLock = new ReentrantLock();
    private final Condition myEventsAvailable = this.myLock.newCondition();
    private volatile E myCurrentEvent;
    private volatile boolean myIsClosed = false;

    public EventQueue(int countPriorities) {
        this.myEvents = new LinkedList[countPriorities];
        for (int i = 0; i < this.myEvents.length; ++i) {
            this.myEvents[i] = new LinkedList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pushBack(@NotNull E event, int priority) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/EventQueue", "pushBack"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("pushBack event " + event);
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).addFirst(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean put(@NotNull E event, int priority) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/impl/EventQueue", "put"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("put event " + event);
        }
        this.myLock.lock();
        try {
            if (this.isClosed()) {
                boolean bl = false;
                return bl;
            }
            this.getEventsList(priority).offer(event);
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
        return true;
    }

    private LinkedList<E> getEventsList(int priority) {
        return this.myEvents[priority];
    }

    public void close() {
        this.myLock.lock();
        try {
            this.myIsClosed = true;
            this.myEventsAvailable.signalAll();
        }
        finally {
            this.myLock.unlock();
        }
    }

    private E getEvent() throws EventQueueClosedException {
        this.myLock.lock();
        try {
            while (true) {
                if (this.myIsClosed) {
                    throw new EventQueueClosedException();
                }
                for (int i = 0; i < this.myEvents.length; ++i) {
                    E event = this.getEventsList(i).poll();
                    if (event == null) continue;
                    E e = event;
                    return e;
                }
                this.myEventsAvailable.awaitUninterruptibly();
            }
        }
        finally {
            this.myLock.unlock();
        }
    }

    public E get() throws EventQueueClosedException {
        try {
            this.myCurrentEvent = this.getEvent();
            return this.myCurrentEvent;
        }
        catch (EventQueueClosedException e) {
            this.myCurrentEvent = null;
            throw e;
        }
    }

    public boolean isClosed() {
        return this.myIsClosed;
    }

    public E getCurrentEvent() {
        return this.myCurrentEvent;
    }

    @NotNull
    public List<E> clearQueue() {
        ArrayList<E> allEvents = new ArrayList<E>();
        for (int i = 0; i < this.myEvents.length; ++i) {
            LinkedList<E> eventList = this.getEventsList(i);
            E event = eventList.poll();
            while (event != null) {
                allEvents.add(event);
                event = eventList.poll();
            }
        }
        ArrayList<E> arrayList = allEvents;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/EventQueue", "clearQueue"));
        }
        return arrayList;
    }

    public void reopen() {
        this.myIsClosed = false;
    }
}

