/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.utils;

import java.awt.Cursor;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import org.jetbrains.annotations.Nullable;

public final class Cursors {
    public static final Cursor RESIZE_ALL = Cursor.getPredefinedCursor(13);
    public static final Cursor CROSS = Cursor.getPredefinedCursor(1);
    public static Cursor NO_CURSOR;

    public static Cursor getSystemNoCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveNoDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getNoCursor() {
        if (NO_CURSOR == null) {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            Image image = toolkit.createImage(Cursors.class.getResource("no-cursor.gif"));
            NO_CURSOR = toolkit.createCustomCursor(image, new Point(), "No_Cursor");
        }
        return NO_CURSOR;
    }

    public static Cursor getMoveCursor() {
        try {
            return Cursor.getSystemCustomCursor("MoveDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    public static Cursor getCopyCursor() {
        try {
            return Cursor.getSystemCustomCursor("CopyDrop.32x32");
        }
        catch (Exception ex) {
            return Cursor.getDefaultCursor();
        }
    }

    @Nullable
    public static Cursor getResizeCursor(int direction) {
        int cursor;
        if (direction == 5) {
            cursor = 6;
        } else if (direction == 1) {
            cursor = 8;
        } else if (direction == 9) {
            cursor = 7;
        } else if (direction == 4) {
            cursor = 10;
        } else if (direction == 8) {
            cursor = 11;
        } else if (direction == 6) {
            cursor = 4;
        } else if (direction == 2) {
            cursor = 9;
        } else if (direction == 10) {
            cursor = 5;
        } else {
            return null;
        }
        return Cursor.getPredefinedCursor(cursor);
    }
}

