/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.diff.util.DiffEmptyHighlighterRenderer;
import com.intellij.diff.util.DiffLineMarkerRenderer;
import com.intellij.diff.util.DiffLineSeparatorRenderer;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.CustomHighlighterRenderer;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.TextRange;
import com.intellij.ui.JBColor;
import com.intellij.util.DocumentUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.CubicCurve2D;
import java.awt.geom.Path2D;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffDrawUtil {
    private static final int STRIPE_LAYER = 4999;
    private static final int DEFAULT_LAYER = 5997;
    private static final int INLINE_LAYER = 5998;
    private static final int LINE_MARKER_LAYER = 5999;
    private static final double CTRL_PROXIMITY_X = 0.3;
    public static final LineSeparatorRenderer BORDER_LINE_RENDERER = new LineSeparatorRenderer(){

        public void drawLine(Graphics g, int x1, int x2, int y) {
            Rectangle clip = g.getClipBounds();
            x2 = clip.x + clip.width;
            g.setColor(JBColor.border());
            g.drawLine(x1, y, x2, y);
        }
    };

    private DiffDrawUtil() {
    }

    @NotNull
    public static Color getDividerColor() {
        Color color = DiffDrawUtil.getDividerColor(null);
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColor(@Nullable Editor editor) {
        Color color = DiffDrawUtil.getDividerColorFromScheme(editor != null ? editor.getColorsScheme() : EditorColorsManager.getInstance().getGlobalScheme());
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColor"));
        }
        return color;
    }

    @NotNull
    public static Color getDividerColorFromScheme(@NotNull EditorColorsScheme scheme) {
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scheme", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        Color gutterBackground = scheme.getColor(EditorColors.GUTTER_BACKGROUND);
        if (gutterBackground == null) {
            gutterBackground = EditorColors.GUTTER_BACKGROUND.getDefaultColor();
        }
        Color color = gutterBackground;
        if (color == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getDividerColorFromScheme"));
        }
        return color;
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffDrawUtil.drawConnectorLineSeparator(g, x1, x2, start1, end1, start2, end2, null);
    }

    public static void drawConnectorLineSeparator(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable EditorColorsScheme scheme) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawConnectorLineSeparator"));
        }
        DiffLineSeparatorRenderer.drawConnectorLine(g, x1, x2, start1, start2, end1 - start1, scheme);
    }

    public static void drawChunkBorderLine(@NotNull Graphics2D g, int x1, int x2, int y, @NotNull Color color, boolean doubleLine, boolean dottedLine) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/diff/util/DiffDrawUtil", "drawChunkBorderLine"));
        }
        if (dottedLine && doubleLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)y, null, (Color)color, (boolean)false);
        } else if (dottedLine) {
            UIUtil.drawBoldDottedLine((Graphics2D)g, (int)x1, (int)x2, (int)(y - 1), null, (Color)color, (boolean)false);
        } else if (doubleLine) {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)(y + 1), (int)x2, (int)(y + 1), null, (Color)color);
        } else {
            UIUtil.drawLine((Graphics2D)g, (int)x1, (int)y, (int)x2, (int)y, null, (Color)color);
        }
    }

    public static void drawTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawTrapezium"));
        }
        if (fillColor != null) {
            int[] xPoints = new int[]{x1, x2, x2, x1};
            int[] yPoints = new int[]{start1, start2, end2 + 1, end1 + 1};
            g.setColor(fillColor);
            g.fillPolygon(xPoints, yPoints, xPoints.length);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.drawLine(x1, start1, x2, start2);
            g.drawLine(x1, end1, x2, end2);
        }
    }

    public static void drawCurveTrapezium(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2, @Nullable Color fillColor, @Nullable Color borderColor) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffDrawUtil", "drawCurveTrapezium"));
        }
        Shape upperCurve = DiffDrawUtil.makeCurve(x1, x2, start1, start2, true);
        Shape lowerCurve = DiffDrawUtil.makeCurve(x1, x2, end1 + 1, end2 + 1, false);
        Shape lowerCurveBorder = DiffDrawUtil.makeCurve(x1, x2, end1, end2, false);
        if (fillColor != null) {
            Path2D.Double path = new Path2D.Double();
            path.append(upperCurve, true);
            path.append(lowerCurve, true);
            g.setColor(fillColor);
            g.fill(path);
        }
        if (borderColor != null) {
            g.setColor(borderColor);
            g.draw(upperCurve);
            g.draw(lowerCurveBorder);
        }
    }

    private static Shape makeCurve(int x1, int x2, int y1, int y2, boolean forward) {
        int width = x2 - x1;
        if (forward) {
            return new CubicCurve2D.Double(x1, y1, (double)x1 + (double)width * 0.3, y1, (double)x1 + (double)width * 0.7, y2, x1 + width, y2);
        }
        return new CubicCurve2D.Double(x1 + width, y2, (double)x1 + (double)width * 0.7, y2, (double)x1 + (double)width * 0.3, y1, x1, y1);
    }

    public static int lineToY(@NotNull Editor editor, int line) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "lineToY"));
        }
        Document document = editor.getDocument();
        if (line >= DiffUtil.getLineCount(document)) {
            int y = DiffDrawUtil.lineToY(editor, DiffUtil.getLineCount(document) - 1);
            return y + editor.getLineHeight() * (line - DiffUtil.getLineCount(document) + 1);
        }
        return editor.logicalPositionToXY((LogicalPosition)editor.offsetToLogicalPosition((int)document.getLineStartOffset((int)line))).y;
    }

    @NotNull
    private static TextAttributes getTextAttributes(final @NotNull TextDiffType type, final @Nullable Editor editor, final boolean ignored) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getBackgroundColor() {
                return ignored ? type.getIgnoredColor(editor) : type.getColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getTextAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    private static TextAttributes getStripeTextAttributes(final @NotNull TextDiffType type, final @NotNull Editor editor) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        TextAttributes textAttributes = new TextAttributes(){

            public Color getErrorStripeColor() {
                return type.getMarkerColor(editor);
            }
        };
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "getStripeTextAttributes"));
        }
        return textAttributes;
    }

    private static void installGutterRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type, boolean ignoredFoldingOutline, boolean resolved, boolean isEmptyRange, boolean isLastLine) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffDrawUtil", "installGutterRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "installGutterRenderer"));
        }
        DiffLineMarkerRenderer renderer = new DiffLineMarkerRenderer(highlighter, type, ignoredFoldingOutline, resolved, isEmptyRange, isLastLine);
        highlighter.setLineMarkerRenderer((LineMarkerRenderer)renderer);
    }

    private static void installEmptyRangeRenderer(@NotNull RangeHighlighter highlighter, @NotNull TextDiffType type) {
        if (highlighter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "highlighter", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "installEmptyRangeRenderer"));
        }
        highlighter.setCustomRenderer((CustomHighlighterRenderer)new DiffEmptyHighlighterRenderer(type));
    }

    @NotNull
    private static LineSeparatorRenderer createDiffLineRenderer(final @NotNull Editor editor, final @NotNull TextDiffType type, final boolean doubleLine, final boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        LineSeparatorRenderer lineSeparatorRenderer = new LineSeparatorRenderer(){

            public void drawLine(Graphics g, int x1, int x2, int y) {
                Rectangle clip = g.getClipBounds();
                x2 = clip.x + clip.width;
                DiffDrawUtil.drawChunkBorderLine((Graphics2D)g, x1, x2, y, type.getColor(editor), doubleLine, resolved);
            }
        };
        if (lineSeparatorRenderer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createDiffLineRenderer"));
        }
        return lineSeparatorRenderer;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).done();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createHighlighter(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type, boolean ignored, boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        List<RangeHighlighter> list = new LineHighlighterBuilder(editor, startLine, endLine, type).withIgnored(ignored).withResolved(resolved).done();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createInlineHighlighter(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        List<RangeHighlighter> list = new InlineHighlighterBuilder(editor, start, end, type).done();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createInlineHighlighter"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line1, int line2, @NotNull TextDiffType type, boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (line1 == line2) {
            if (line1 == 0) {
                List<RangeHighlighter> list = Collections.emptyList();
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
                }
                return list;
            }
            List<RangeHighlighter> list = DiffDrawUtil.createLineMarker(editor, line1 - 1, type, SeparatorPlacement.BOTTOM, true, resolved);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
            }
            return list;
        }
        List list = ContainerUtil.concat(DiffDrawUtil.createLineMarker(editor, line1, type, SeparatorPlacement.TOP, false, resolved), DiffDrawUtil.createLineMarker(editor, line2 - 1, type, SeparatorPlacement.BOTTOM, false, resolved));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        List<RangeHighlighter> list = new LineMarkerBuilder(editor, line, placement).withType(type).doneDefaultRenderer();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    private static List<RangeHighlighter> createLineMarker(@NotNull Editor editor, int line, @NotNull TextDiffType type, @NotNull SeparatorPlacement placement, boolean doubleLine, boolean resolved) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        List<RangeHighlighter> list = new LineMarkerBuilder(editor, line, placement).withType(type).withResolved(resolved).doneDefaultRenderer(doubleLine);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createBorderLineMarker(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        List<RangeHighlighter> list = new LineMarkerBuilder(editor, line, placement).withRenderer(BORDER_LINE_RENDERER).done();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createBorderLineMarker"));
        }
        return list;
    }

    @NotNull
    public static List<RangeHighlighter> createLineSeparatorHighlighter(@NotNull Editor editor, int offset1, int offset2, @NotNull BooleanGetter condition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        RangeHighlighter marker = editor.getMarkupModel().addRangeHighlighter(offset1, offset2, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
        DiffLineSeparatorRenderer renderer = new DiffLineSeparatorRenderer(editor, condition);
        marker.setLineSeparatorPlacement(SeparatorPlacement.TOP);
        marker.setLineSeparatorRenderer((LineSeparatorRenderer)renderer);
        marker.setLineMarkerRenderer((LineMarkerRenderer)renderer);
        List<RangeHighlighter> list = Collections.singletonList(marker);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil", "createLineSeparatorHighlighter"));
        }
        return list;
    }

    private static class LineMarkerBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final SeparatorPlacement placement;
        private final int line;
        private boolean resolved;
        @Nullable
        private TextDiffType type;
        @Nullable
        private LineSeparatorRenderer renderer;

        private LineMarkerBuilder(@NotNull Editor editor, int line, @NotNull SeparatorPlacement placement) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "<init>"));
            }
            if (placement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "<init>"));
            }
            this.resolved = false;
            this.editor = editor;
            this.line = line;
            this.placement = placement;
        }

        @NotNull
        public LineMarkerBuilder withType(@NotNull TextDiffType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withType"));
            }
            this.type = type;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withType"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withResolved"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public LineMarkerBuilder withRenderer(@NotNull LineSeparatorRenderer renderer) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withRenderer"));
            }
            this.renderer = renderer;
            LineMarkerBuilder lineMarkerBuilder = this;
            if (lineMarkerBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "withRenderer"));
            }
            return lineMarkerBuilder;
        }

        @NotNull
        public List<RangeHighlighter> doneDefaultRenderer() {
            List<RangeHighlighter> list = this.doneDefaultRenderer(false);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "doneDefaultRenderer"));
            }
            return list;
        }

        @NotNull
        public List<RangeHighlighter> doneDefaultRenderer(boolean doubleLine) {
            assert (this.type != null);
            this.renderer = DiffDrawUtil.createDiffLineRenderer(this.editor, this.type, doubleLine, this.resolved);
            List<RangeHighlighter> list = this.done();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "doneDefaultRenderer"));
            }
            return list;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            int offset = DocumentUtil.getFirstNonSpaceCharOffset(this.editor.getDocument(), this.line);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 5999, null, HighlighterTargetArea.LINES_IN_RANGE);
            highlighter.setLineSeparatorPlacement(this.placement);
            highlighter.setLineSeparatorRenderer(this.renderer);
            if (this.type == null || this.resolved) {
                List<RangeHighlighter> list = Collections.singletonList(highlighter);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "done"));
                }
                return list;
            }
            TextAttributes stripeAttributes = DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(offset, offset, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List list = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineMarkerBuilder", "done"));
            }
            return list;
        }
    }

    private static class InlineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int start;
        private final int end;

        private InlineHighlighterBuilder(@NotNull Editor editor, int start, int end, @NotNull TextDiffType type) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "<init>"));
            }
            this.editor = editor;
            this.type = type;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            TextAttributes attributes = DiffDrawUtil.getTextAttributes(this.type, this.editor, false);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(this.start, this.end, 5998, attributes, HighlighterTargetArea.EXACT_RANGE);
            if (this.start == this.end) {
                DiffDrawUtil.installEmptyRangeRenderer(highlighter, this.type);
            }
            List<RangeHighlighter> list = Collections.singletonList(highlighter);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$InlineHighlighterBuilder", "done"));
            }
            return list;
        }
    }

    private static class LineHighlighterBuilder {
        @NotNull
        private final Editor editor;
        @NotNull
        private final TextDiffType type;
        private final int startLine;
        private final int endLine;
        private boolean ignored;
        private boolean resolved;

        private LineHighlighterBuilder(@NotNull Editor editor, int startLine, int endLine, @NotNull TextDiffType type) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "<init>"));
            }
            this.ignored = false;
            this.resolved = false;
            this.editor = editor;
            this.type = type;
            this.startLine = startLine;
            this.endLine = endLine;
        }

        @NotNull
        public LineHighlighterBuilder withIgnored(boolean ignored) {
            this.ignored = ignored;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "withIgnored"));
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public LineHighlighterBuilder withResolved(boolean resolved) {
            this.resolved = resolved;
            LineHighlighterBuilder lineHighlighterBuilder = this;
            if (lineHighlighterBuilder == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "withResolved"));
            }
            return lineHighlighterBuilder;
        }

        @NotNull
        public List<RangeHighlighter> done() {
            boolean isEmptyRange = this.startLine == this.endLine;
            boolean isLastLine = this.endLine == DiffUtil.getLineCount(this.editor.getDocument());
            TextRange offsets = DiffUtil.getLinesRange(this.editor.getDocument(), this.startLine, this.endLine);
            int start = offsets.getStartOffset();
            int end = offsets.getEndOffset();
            TextAttributes attributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getTextAttributes(this.type, this.editor, this.ignored);
            TextAttributes stripeAttributes = isEmptyRange || this.resolved ? null : DiffDrawUtil.getStripeTextAttributes(this.type, this.editor);
            RangeHighlighter highlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 5997, attributes, HighlighterTargetArea.LINES_IN_RANGE);
            DiffDrawUtil.installGutterRenderer(highlighter, this.type, this.ignored, this.resolved, isEmptyRange, isLastLine);
            if (stripeAttributes == null) {
                List<RangeHighlighter> list = Collections.singletonList(highlighter);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "done"));
                }
                return list;
            }
            RangeHighlighter stripeHighlighter = this.editor.getMarkupModel().addRangeHighlighter(start, end, 4999, stripeAttributes, HighlighterTargetArea.LINES_IN_RANGE);
            List list = ContainerUtil.list((Object[])new RangeHighlighter[]{highlighter, stripeHighlighter});
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffDrawUtil$LineHighlighterBuilder", "done"));
            }
            return list;
        }
    }
}

