/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.lineMarker;

import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.execution.lineMarker.LineMarkerActionWrapper;
import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.psi.PsiElement;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunLineMarkerProvider
extends LineMarkerProviderDescriptor {
    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "getLineMarkerInfo"));
        }
        List contributors = RunLineMarkerContributor.EXTENSION.allForLanguage(element.getLanguage());
        DefaultActionGroup actionGroup = null;
        Icon icon = null;
        final ArrayList<RunLineMarkerContributor.Info> infos = new ArrayList<RunLineMarkerContributor.Info>();
        for (RunLineMarkerContributor contributor : contributors) {
            RunLineMarkerContributor.Info info = contributor.getInfo(element);
            if (info == null) continue;
            if (icon == null) {
                icon = info.icon;
            }
            if (actionGroup == null) {
                actionGroup = new DefaultActionGroup();
            }
            infos.add(info);
            for (AnAction action : info.actions) {
                actionGroup.add((AnAction)new LineMarkerActionWrapper(element, action));
            }
            actionGroup.add((AnAction)new Separator());
        }
        if (icon == null) {
            return null;
        }
        final DefaultActionGroup finalActionGroup = actionGroup;
        Function<PsiElement, String> tooltipProvider = new Function<PsiElement, String>(){

            public String fun(PsiElement element) {
                StringBuilder tooltip = new StringBuilder();
                for (RunLineMarkerContributor.Info info : infos) {
                    String string;
                    if (info.tooltipProvider == null || (string = (String)info.tooltipProvider.fun((Object)element)) == null) continue;
                    if (tooltip.length() != 0) {
                        tooltip.append("\n");
                    }
                    tooltip.append(string);
                }
                return tooltip.length() == 0 ? null : tooltip.toString();
            }
        };
        return new LineMarkerInfo<PsiElement>(element, element.getTextRange(), icon, 4, (Function)tooltipProvider, null, GutterIconRenderer.Alignment.CENTER){

            @Nullable
            public GutterIconRenderer createGutterRenderer() {
                return new LineMarkerInfo.LineMarkerGutterIconRenderer<PsiElement>((LineMarkerInfo)this){

                    public AnAction getClickAction() {
                        return null;
                    }

                    public boolean isNavigateAction() {
                        return true;
                    }

                    @Nullable
                    public ActionGroup getPopupMenuActions() {
                        return finalActionGroup;
                    }
                };
            }
        };
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "collectSlowLineMarkers"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "collectSlowLineMarkers"));
        }
    }

    @NotNull
    public String getName() {
        if ("Run line marker" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/lineMarker/RunLineMarkerProvider", "getName"));
        }
        return "Run line marker";
    }

    @Nullable
    public Icon getIcon() {
        return AllIcons.RunConfigurations.TestState.Run;
    }
}

