/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.process;

import java.io.InputStream;
import java.io.OutputStream;
import org.jetbrains.annotations.NotNull;

public class ProcessWrapper
extends Process {
    @NotNull
    private final Process myOriginalProcess;

    public ProcessWrapper(@NotNull Process originalProcess) {
        if (originalProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalProcess", "com/intellij/execution/process/ProcessWrapper", "<init>"));
        }
        this.myOriginalProcess = originalProcess;
    }

    @Override
    public OutputStream getOutputStream() {
        return this.myOriginalProcess.getOutputStream();
    }

    @Override
    public InputStream getInputStream() {
        return this.myOriginalProcess.getInputStream();
    }

    @Override
    public InputStream getErrorStream() {
        return this.myOriginalProcess.getErrorStream();
    }

    @Override
    public int waitFor() throws InterruptedException {
        return this.myOriginalProcess.waitFor();
    }

    @Override
    public int exitValue() {
        return this.myOriginalProcess.exitValue();
    }

    @Override
    public void destroy() {
        this.myOriginalProcess.destroy();
    }

    @NotNull
    public Process getOriginalProcess() {
        Process process = this.myOriginalProcess;
        if (process == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/process/ProcessWrapper", "getOriginalProcess"));
        }
        return process;
    }
}

