/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.find.FindBundle;
import com.intellij.lang.Language;
import com.intellij.lang.findUsages.EmptyFindUsagesProvider;
import com.intellij.lang.findUsages.LanguageFindUsages;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import javax.swing.Icon;

public class FindUsagesInFileAction
extends AnAction {
    public FindUsagesInFileAction() {
        this.setInjectedContext(true);
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        UsageTarget[] usageTargets = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataContext);
        if (usageTargets != null) {
            FileEditor fileEditor = (FileEditor)PlatformDataKeys.FILE_EDITOR.getData(dataContext);
            if (fileEditor != null) {
                usageTargets[0].findUsagesInEditor(fileEditor);
            }
        } else if (editor == null) {
            Messages.showMessageDialog((Project)project2, (String)FindBundle.message("find.no.usages.at.cursor.error", new Object[0]), (String)CommonBundle.getErrorTitle(), (Icon)Messages.getErrorIcon());
        } else {
            HintManager.getInstance().showErrorHint(editor, FindBundle.message("find.no.usages.at.cursor.error", new Object[0]));
        }
    }

    public void update(AnActionEvent event) {
        FindUsagesInFileAction.updateFindUsagesAction(event);
    }

    private static boolean isEnabled(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return false;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (editor == null) {
            UsageTarget[] target = (UsageTarget[])UsageView.USAGE_TARGETS_KEY.getData(dataContext);
            return target != null && target.length > 0;
        }
        PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
        if (file2 == null) {
            return false;
        }
        Language language = PsiUtilBase.getLanguageInEditor((Editor)editor, (Project)project2);
        if (language == null) {
            language = file2.getLanguage();
        }
        return !(LanguageFindUsages.INSTANCE.forLanguage(language) instanceof EmptyFindUsagesProvider);
    }

    public static void updateFindUsagesAction(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        boolean enabled = FindUsagesInFileAction.isEnabled(dataContext);
        presentation.setVisible(enabled || !ActionPlaces.isPopupPlace((String)event.getPlace()));
        presentation.setEnabled(enabled);
    }
}

