/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.findUsages;

import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class PsiElement2UsageTargetComposite
extends PsiElement2UsageTargetAdapter {
    private final UsageInfoToUsageConverter.TargetElementsDescriptor myDescriptor;

    public PsiElement2UsageTargetComposite(@NotNull PsiElement[] primaryElements, @NotNull PsiElement[] secondaryElements, @NotNull FindUsagesOptions options) {
        if (primaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "primaryElements", "com/intellij/find/findUsages/PsiElement2UsageTargetComposite", "<init>"));
        }
        if (secondaryElements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "secondaryElements", "com/intellij/find/findUsages/PsiElement2UsageTargetComposite", "<init>"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/findUsages/PsiElement2UsageTargetComposite", "<init>"));
        }
        super(primaryElements[0], options);
        this.myDescriptor = new UsageInfoToUsageConverter.TargetElementsDescriptor(primaryElements, secondaryElements);
    }

    @Override
    public void findUsages() {
        PsiElement element = this.getElement();
        if (element == null) {
            return;
        }
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)element.getProject())).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, false);
        boolean skipResultsWithOneUsage = FindSettings.getInstance().isSkipResultsWithOneUsage();
        findUsagesManager.findUsages(this.myDescriptor.getPrimaryElements(), this.myDescriptor.getAdditionalElements(), handler2, this.myOptions, skipResultsWithOneUsage);
    }

    @Override
    public VirtualFile[] getFiles() {
        Set files = ContainerUtil.map2Set((Collection)this.myDescriptor.getAllElements(), (Function)new Function<PsiElement, VirtualFile>(){

            public VirtualFile fun(PsiElement element) {
                return PsiUtilCore.getVirtualFile((PsiElement)element);
            }
        });
        return VfsUtilCore.toVirtualFileArray((Collection)files);
    }

    @NotNull
    public PsiElement[] getPrimaryElements() {
        PsiElement[] psiElementArray = this.myDescriptor.getPrimaryElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/PsiElement2UsageTargetComposite", "getPrimaryElements"));
        }
        return psiElementArray;
    }

    @NotNull
    public PsiElement[] getSecondaryElements() {
        PsiElement[] psiElementArray = this.myDescriptor.getAdditionalElements();
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/findUsages/PsiElement2UsageTargetComposite", "getSecondaryElements"));
        }
        return psiElementArray;
    }
}

