/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserManager;
import com.intellij.ide.browsers.actions.BaseWebBrowserAction;
import com.intellij.ide.browsers.actions.OpenFileInDefaultBrowserAction;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ComputableActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.psi.util.CachedValueProvider;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OpenInBrowserBaseGroupAction
extends ComputableActionGroup {
    private OpenFileInDefaultBrowserAction myDefaultBrowserAction;

    protected OpenInBrowserBaseGroupAction(boolean popup) {
        super(popup);
        Presentation p = this.getTemplatePresentation();
        p.setText("Open in _Browser");
        p.setDescription("Open selected file in browser");
        p.setIcon(AllIcons.Nodes.PpWeb);
    }

    @Override
    @NotNull
    protected final CachedValueProvider<AnAction[]> createChildrenProvider(@NotNull ActionManager actionManager) {
        if (actionManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actionManager", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction", "createChildrenProvider"));
        }
        CachedValueProvider<AnAction[]> cachedValueProvider = new CachedValueProvider<AnAction[]>(){

            @Nullable
            public CachedValueProvider.Result<AnAction[]> compute() {
                List<WebBrowser> browsers = WebBrowserManager.getInstance().getBrowsers();
                boolean addDefaultBrowser = OpenInBrowserBaseGroupAction.this.isPopup();
                int offset = addDefaultBrowser ? 1 : 0;
                AnAction[] actions = new AnAction[browsers.size() + offset];
                if (addDefaultBrowser) {
                    if (OpenInBrowserBaseGroupAction.this.myDefaultBrowserAction == null) {
                        OpenInBrowserBaseGroupAction.this.myDefaultBrowserAction = new OpenFileInDefaultBrowserAction();
                        OpenInBrowserBaseGroupAction.this.myDefaultBrowserAction.getTemplatePresentation().setText("Default");
                        OpenInBrowserBaseGroupAction.this.myDefaultBrowserAction.getTemplatePresentation().setIcon(AllIcons.Nodes.PpWeb);
                    }
                    actions[0] = OpenInBrowserBaseGroupAction.this.myDefaultBrowserAction;
                }
                int size = browsers.size();
                for (int i = 0; i < size; ++i) {
                    actions[i + offset] = new BaseWebBrowserAction(browsers.get(i));
                }
                return CachedValueProvider.Result.create((Object)actions, (Object[])new Object[]{WebBrowserManager.getInstance()});
            }
        };
        if (cachedValueProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction", "createChildrenProvider"));
        }
        return cachedValueProvider;
    }

    public static final class OpenInBrowserEditorContextBarGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserEditorContextBarGroupAction() {
            super(false);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/browsers/actions/OpenInBrowserBaseGroupAction$OpenInBrowserEditorContextBarGroupAction", "update"));
            }
            WebBrowserManager browserManager = WebBrowserManager.getInstance();
            e.getPresentation().setVisible(browserManager.isShowBrowserHover() && !browserManager.getActiveBrowsers().isEmpty());
        }
    }

    public static final class OpenInBrowserGroupAction
    extends OpenInBrowserBaseGroupAction {
        public OpenInBrowserGroupAction() {
            super(true);
        }
    }
}

