/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.FTManager;
import com.intellij.ide.fileTemplates.impl.FileTemplateBase;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import java.util.List;
import java.util.Locale;
import org.jdom.Element;
import org.jetbrains.annotations.Nullable;

@State(name="ExportableFileTemplateSettings", storages={@Storage(value="file.template.settings.xml")}, additionalExportFile="fileTemplates")
public class ExportableFileTemplateSettings
implements PersistentStateComponent<Element> {
    public static final String EXPORTABLE_SETTINGS_FILE = "file.template.settings.xml";
    static final String ELEMENT_TEMPLATE = "template";
    static final String ATTRIBUTE_NAME = "name";
    static final String ATTRIBUTE_REFORMAT = "reformat";
    static final String ATTRIBUTE_LIVE_TEMPLATE = "live-template-enabled";
    static final String ATTRIBUTE_ENABLED = "enabled";
    private final Project myProject;

    public ExportableFileTemplateSettings(Project project2) {
        this.myProject = project2;
    }

    static ExportableFileTemplateSettings getInstance(Project project2) {
        return (ExportableFileTemplateSettings)ServiceManager.getService((Project)project2, ExportableFileTemplateSettings.class);
    }

    @Nullable
    public Element getState() {
        Element element = null;
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = null;
            for (FileTemplateBase template : manager.getAllTemplates(true)) {
                boolean shouldSave;
                boolean bl = shouldSave = !template.isReformatCode() || template.isLiveTemplateEnabled() != template.isLiveTemplateEnabledByDefault();
                if (template instanceof BundledFileTemplate) {
                    shouldSave |= !((BundledFileTemplate)template).isEnabled();
                }
                if (!shouldSave) continue;
                Element templateElement = new Element(ELEMENT_TEMPLATE);
                templateElement.setAttribute(ATTRIBUTE_NAME, template.getQualifiedName());
                templateElement.setAttribute(ATTRIBUTE_REFORMAT, Boolean.toString(template.isReformatCode()));
                templateElement.setAttribute(ATTRIBUTE_LIVE_TEMPLATE, Boolean.toString(template.isLiveTemplateEnabled()));
                if (template instanceof BundledFileTemplate) {
                    templateElement.setAttribute(ATTRIBUTE_ENABLED, Boolean.toString(((BundledFileTemplate)template).isEnabled()));
                }
                if (templatesGroup == null) {
                    templatesGroup = new Element(ExportableFileTemplateSettings.getXmlElementGroupName(manager));
                    if (element == null) {
                        element = new Element("fileTemplateSettings");
                    }
                    element.addContent(templatesGroup);
                }
                templatesGroup.addContent(templateElement);
            }
        }
        return element;
    }

    private FTManager[] getAllManagers() {
        return FileTemplateManagerImpl.getInstanceImpl(this.myProject).getAllManagers();
    }

    public void loadState(Element state) {
        this.doLoad(state);
    }

    private void doLoad(Element element) {
        for (FTManager manager : this.getAllManagers()) {
            Element templatesGroup = element.getChild(ExportableFileTemplateSettings.getXmlElementGroupName(manager));
            if (templatesGroup == null) continue;
            List children2 = templatesGroup.getChildren(ELEMENT_TEMPLATE);
            for (Object elem : children2) {
                Element child = (Element)elem;
                String qName = child.getAttributeValue(ATTRIBUTE_NAME);
                FileTemplateBase template = manager.getTemplate(qName);
                if (template == null) continue;
                template.setReformatCode(Boolean.TRUE.toString().equals(child.getAttributeValue(ATTRIBUTE_REFORMAT)));
                template.setLiveTemplateEnabled(Boolean.TRUE.toString().equals(child.getAttributeValue(ATTRIBUTE_LIVE_TEMPLATE)));
                if (!(template instanceof BundledFileTemplate)) continue;
                boolean enabled = Boolean.parseBoolean(child.getAttributeValue(ATTRIBUTE_ENABLED, "true"));
                ((BundledFileTemplate)template).setEnabled(enabled);
            }
        }
    }

    private static String getXmlElementGroupName(FTManager manager) {
        return manager.getName().toLowerCase(Locale.US) + "_templates";
    }
}

