/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.impl.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.LibraryGroupNode;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElement;
import com.intellij.ide.projectView.impl.nodes.NamedLibraryElementNode;
import com.intellij.ide.projectView.impl.nodes.PsiDirectoryNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrSdkOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiManager;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ExternalLibrariesNode
extends ProjectViewNode<String> {
    public ExternalLibrariesNode(Project project2, ViewSettings viewSettings) {
        super(project2, (Object)"External Libraries", viewSettings);
    }

    public boolean contains(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode", "contains"));
        }
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        if (!index.isInLibrarySource(file2) && !index.isInLibraryClasses(file2)) {
            return false;
        }
        return this.someChildContainsFile(file2, false);
    }

    @NotNull
    public Collection<? extends AbstractTreeNode> getChildren() {
        ArrayList<AbstractTreeNode> children2 = new ArrayList<AbstractTreeNode>();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)this.getProject()).getFileIndex();
        Module[] modules = ModuleManager.getInstance((Project)this.getProject()).getModules();
        THashSet processedLibraries = new THashSet();
        THashSet processedSdk = new THashSet();
        for (Module module2 : modules) {
            OrderEntry[] orderEntries;
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
            for (OrderEntry orderEntry : orderEntries = moduleRootManager.getOrderEntries()) {
                JdkOrderEntry jdkOrderEntry;
                Sdk jdk;
                if (orderEntry instanceof LibraryOrderEntry) {
                    LibraryOrderEntry libraryOrderEntry = (LibraryOrderEntry)orderEntry;
                    Library library = libraryOrderEntry.getLibrary();
                    if (library == null || processedLibraries.contains(library)) continue;
                    processedLibraries.add(library);
                    if (!ExternalLibrariesNode.hasExternalEntries(fileIndex, libraryOrderEntry)) continue;
                    String libraryName = library.getName();
                    if (libraryName == null || libraryName.length() == 0) {
                        ExternalLibrariesNode.addLibraryChildren(libraryOrderEntry, children2, this.getProject(), this);
                        continue;
                    }
                    children2.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)libraryOrderEntry), this.getSettings()));
                    continue;
                }
                if (!(orderEntry instanceof JdkOrderEntry) || (jdk = (jdkOrderEntry = (JdkOrderEntry)orderEntry).getJdk()) == null || processedSdk.contains(jdk)) continue;
                processedSdk.add(jdk);
                children2.add((AbstractTreeNode)new NamedLibraryElementNode(this.getProject(), new NamedLibraryElement(null, (LibraryOrSdkOrderEntry)jdkOrderEntry), this.getSettings()));
            }
        }
        ArrayList<AbstractTreeNode> arrayList = children2;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/projectView/impl/nodes/ExternalLibrariesNode", "getChildren"));
        }
        return arrayList;
    }

    public static void addLibraryChildren(LibraryOrderEntry entry, List<AbstractTreeNode> children2, Project project2, ProjectViewNode node) {
        VirtualFile[] files;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        for (VirtualFile file2 : files = entry.getRootFiles(OrderRootType.CLASSES)) {
            PsiDirectory psiDir = psiManager.findDirectory(file2);
            if (psiDir == null) continue;
            children2.add((AbstractTreeNode)new PsiDirectoryNode(project2, psiDir, node.getSettings()));
        }
    }

    private static boolean hasExternalEntries(ProjectFileIndex index, LibraryOrderEntry orderEntry) {
        for (VirtualFile file2 : LibraryGroupNode.getLibraryRoots(orderEntry)) {
            if (index.isInContent(PathUtil.getLocalFile((VirtualFile)file2))) continue;
            return true;
        }
        return false;
    }

    protected void update(PresentationData presentation) {
        presentation.setPresentableText(IdeBundle.message((String)"node.projectview.external.libraries", (Object[])new Object[0]));
        presentation.setIcon(PlatformIcons.LIBRARY_ICON);
    }
}

