/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectWizard.ChooseTemplateStep;
import com.intellij.ide.projectWizard.ProjectSettingsStep;
import com.intellij.ide.projectWizard.ProjectTypeStep;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Disposer;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NewProjectWizard
extends AbstractProjectWizard {
    private final StepSequence mySequence;

    public NewProjectWizard(@Nullable Project project2, @NotNull ModulesProvider modulesProvider, @Nullable String defaultPath) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/projectWizard/NewProjectWizard", "<init>"));
        }
        super(project2 == null ? IdeBundle.message((String)"title.new.project", (Object[])new Object[0]) : IdeBundle.message((String)"title.add.module", (Object[])new Object[0]), project2, defaultPath);
        this.mySequence = new StepSequence(new ModuleWizardStep[0]);
        this.init(modulesProvider);
    }

    public NewProjectWizard(Project project2, Component dialogParent, ModulesProvider modulesProvider) {
        super(IdeBundle.message((String)"title.add.module", (Object[])new Object[0]), project2, dialogParent);
        this.mySequence = new StepSequence(new ModuleWizardStep[0]);
        this.init(modulesProvider);
    }

    protected void init(@NotNull ModulesProvider modulesProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/projectWizard/NewProjectWizard", "init"));
        }
        this.myWizardContext.setNewWizard(true);
        this.myWizardContext.setModulesProvider(modulesProvider);
        ProjectTypeStep projectTypeStep = new ProjectTypeStep(this.myWizardContext, this, modulesProvider);
        Disposer.register((Disposable)this.getDisposable(), (Disposable)projectTypeStep);
        this.mySequence.addCommonStep(projectTypeStep);
        ChooseTemplateStep chooseTemplateStep = new ChooseTemplateStep(this.myWizardContext, projectTypeStep);
        this.mySequence.addCommonStep(chooseTemplateStep);
        this.mySequence.addCommonFinishingStep(new ProjectSettingsStep(this.myWizardContext), null);
        for (ModuleWizardStep step : this.mySequence.getAllSteps()) {
            this.addStep((Step)step);
        }
        if (this.myWizardContext.isCreatingNewProject()) {
            projectTypeStep.loadRemoteTemplates(chooseTemplateStep);
        }
        super.init();
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "new project wizard";
    }

    @Override
    public StepSequence getSequence() {
        return this.mySequence;
    }
}

