/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.structureView.impl;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.roots.ui.CellAppearanceEx;
import com.intellij.openapi.roots.ui.FileAppearanceService;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocCommentOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.jetbrains.annotations.NotNull;

public class StructureNodeRenderer
extends ColoredTreeCellRenderer {
    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ide/structureView/impl/StructureNodeRenderer", "customizeCellRenderer"));
        }
        StructureNodeRenderer.forNodeDescriptorInTree(value, expanded).customize((SimpleColoredComponent)this);
    }

    public static CellAppearanceEx forNodeDescriptorInTree(Object node, boolean expanded) {
        CompositeAppearance result;
        NodeDescriptor descriptor = StructureNodeRenderer.getNodeDescriptor(node);
        if (descriptor == null) {
            return FileAppearanceService.getInstance().empty();
        }
        String name = descriptor.toString();
        Object psiElement = descriptor.getElement();
        if (psiElement instanceof PsiElement && !((PsiElement)psiElement).isValid()) {
            result = CompositeAppearance.single((String)name);
        } else {
            PsiClass psiClass = StructureNodeRenderer.getContainingClass(psiElement);
            if (StructureNodeRenderer.isInheritedMember(node, psiClass) && psiClass != null) {
                CompositeAppearance.DequeEnd ending = new CompositeAppearance().getEnding();
                ending.addText(name, StructureNodeRenderer.applyDeprecation(psiElement, SimpleTextAttributes.DARK_TEXT));
                ending.addComment(psiClass.getName(), StructureNodeRenderer.applyDeprecation(psiClass, SimpleTextAttributes.GRAY_ATTRIBUTES));
                result = ending.getAppearance();
            } else {
                SimpleTextAttributes textAttributes = StructureNodeRenderer.applyDeprecation(psiElement, SimpleTextAttributes.REGULAR_ATTRIBUTES);
                result = CompositeAppearance.single((String)name, (SimpleTextAttributes)textAttributes);
            }
        }
        result.setIcon(descriptor.getIcon());
        return result;
    }

    private static boolean isInheritedMember(Object node, PsiClass psiClass) {
        PsiClass treeParentClass = StructureNodeRenderer.getTreeParentClass(node);
        return treeParentClass != psiClass;
    }

    public static SimpleTextAttributes applyDeprecation(Object value, SimpleTextAttributes nameAttributes) {
        return StructureNodeRenderer.isDeprecated(value) ? StructureNodeRenderer.makeStrikeout(nameAttributes) : nameAttributes;
    }

    private static SimpleTextAttributes makeStrikeout(SimpleTextAttributes nameAttributes) {
        return new SimpleTextAttributes(nameAttributes.getStyle() | 4, nameAttributes.getFgColor());
    }

    private static boolean isDeprecated(Object psiElement) {
        return psiElement instanceof PsiDocCommentOwner && ((PsiDocCommentOwner)psiElement).isDeprecated();
    }

    private static PsiClass getContainingClass(Object element) {
        if (element instanceof PsiMember) {
            return ((PsiMember)element).getContainingClass();
        }
        return null;
    }

    private static PsiClass getTreeParentClass(Object value) {
        if (!(value instanceof TreeNode)) {
            return null;
        }
        for (TreeNode treeNode = ((TreeNode)value).getParent(); treeNode != null; treeNode = treeNode.getParent()) {
            Object element = StructureNodeRenderer.getElement(treeNode);
            if (!(element instanceof PsiClass)) continue;
            return (PsiClass)element;
        }
        return null;
    }

    private static NodeDescriptor getNodeDescriptor(Object value) {
        DefaultMutableTreeNode node;
        Object userObject;
        if (value instanceof DefaultMutableTreeNode && (userObject = (node = (DefaultMutableTreeNode)value).getUserObject()) instanceof NodeDescriptor) {
            return (NodeDescriptor)userObject;
        }
        return null;
    }

    private static Object getElement(Object node) {
        NodeDescriptor descriptor = StructureNodeRenderer.getNodeDescriptor(node);
        return descriptor == null ? null : descriptor.getElement();
    }
}

