/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.ui.laf.intellij;

import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.ide.ui.laf.intellij.MacIntelliJButtonBorder;
import com.intellij.ide.ui.laf.intellij.MacIntelliJIconCache;
import com.intellij.ui.Gray;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.text.View;
import sun.swing.SwingUtilities2;

public class MacIntelliJButtonUI
extends DarculaButtonUI {
    private static Rectangle viewRect = new Rectangle();
    private static Rectangle textRect = new Rectangle();
    private static Rectangle iconRect = new Rectangle();

    public static ComponentUI createUI(JComponent c) {
        return new MacIntelliJButtonUI();
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        if (!(c.getBorder() instanceof MacIntelliJButtonBorder) && !MacIntelliJButtonUI.isComboButton(c)) {
            super.paint(g, c);
            return;
        }
        int w = c.getWidth();
        int h = c.getHeight();
        if (MacIntelliJButtonUI.isHelpButton(c)) {
            Icon icon = MacIntelliJIconCache.getIcon("helpButton", false, c.hasFocus());
            int x = (w - icon.getIconWidth()) / 2;
            int y = (h - icon.getIconHeight()) / 2;
            icon.paintIcon(c, g, x, y);
        } else {
            AbstractButton b = (AbstractButton)c;
            String text = this.layout(b, SwingUtilities2.getFontMetrics((JComponent)b, g), b.getWidth(), b.getHeight());
            boolean isFocused = c.hasFocus();
            if (MacIntelliJButtonUI.isSquare(c)) {
                Icon icon = MacIntelliJIconCache.getIcon("browseButton");
                int x = (c.getWidth() - icon.getIconWidth()) / 2;
                int y = (c.getHeight() - icon.getIconHeight()) / 2;
                icon.paintIcon(c, g, x, y);
                return;
            }
            int x = isFocused ? 0 : 2;
            int y = isFocused ? 0 : (h - MacIntelliJButtonUI.viewRect.height) / 2;
            Icon icon = MacIntelliJButtonUI.getLeftIcon(b);
            icon.paintIcon(b, g, x, y);
            int stop2 = w - (isFocused ? 0 : 2) - MacIntelliJButtonUI.getRightIcon(b).getIconWidth();
            Graphics gg = g.create(0, 0, w, h);
            gg.setClip(x += icon.getIconWidth(), y, stop2 - x, h);
            icon = MacIntelliJButtonUI.getMiddleIcon(b);
            while (x < stop2) {
                icon.paintIcon(b, gg, x, y);
                x += icon.getIconWidth();
            }
            gg.dispose();
            icon = MacIntelliJButtonUI.getRightIcon(b);
            icon.paintIcon(b, g, stop2, y);
            this.clearTextShiftOffset();
            if (b.getIcon() != null) {
                this.paintIcon(g, c, iconRect);
            }
            if (text != null && !text.isEmpty()) {
                View v = (View)c.getClientProperty("html");
                if (v != null) {
                    v.paint(g, textRect);
                } else {
                    this.paintText(g, b, textRect, text);
                }
            }
        }
    }

    protected static boolean isComboButton(JComponent c) {
        return c instanceof AbstractButton && c.getClientProperty("styleCombo") == Boolean.TRUE;
    }

    private static Icon getLeftIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Left", button);
    }

    private static Icon getMiddleIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Middle", button);
    }

    private static Icon getRightIcon(AbstractButton button) {
        return MacIntelliJButtonUI.getIcon("Right", button);
    }

    private static Icon getIcon(String suffix, AbstractButton button) {
        boolean isDefault = MacIntelliJButtonUI.isDefaultButton(button);
        boolean isFocused = button.hasFocus();
        boolean combo = MacIntelliJButtonUI.isComboButton(button);
        String comboPrefix = combo ? "Combo" : "";
        String iconName = "button" + comboPrefix + suffix;
        return MacIntelliJIconCache.getIcon(iconName, isDefault, isFocused && !combo);
    }

    private String layout(AbstractButton b, FontMetrics fm, int width, int height) {
        Insets i = b.getInsets();
        MacIntelliJButtonUI.viewRect.x = i.left;
        MacIntelliJButtonUI.viewRect.y = i.top;
        MacIntelliJButtonUI.viewRect.width = width - (i.right + MacIntelliJButtonUI.viewRect.x);
        MacIntelliJButtonUI.viewRect.height = height - (i.bottom + MacIntelliJButtonUI.viewRect.y);
        MacIntelliJButtonUI.textRect.height = 0;
        MacIntelliJButtonUI.textRect.width = 0;
        MacIntelliJButtonUI.textRect.y = 0;
        MacIntelliJButtonUI.textRect.x = 0;
        MacIntelliJButtonUI.iconRect.height = 0;
        MacIntelliJButtonUI.iconRect.width = 0;
        MacIntelliJButtonUI.iconRect.y = 0;
        MacIntelliJButtonUI.iconRect.x = 0;
        if (MacIntelliJButtonUI.isComboButton(b)) {
            MacIntelliJButtonUI.viewRect.x += 6;
        }
        return SwingUtilities.layoutCompoundLabel(b, fm, b.getText(), b.getIcon(), b.getVerticalAlignment(), b.getHorizontalAlignment(), b.getVerticalTextPosition(), b.getHorizontalTextPosition(), viewRect, iconRect, textRect, b.getText() == null ? 0 : b.getIconTextGap());
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension size = super.getPreferredSize(c);
        if (c.getBorder() instanceof MacIntelliJButtonBorder || MacIntelliJButtonUI.isComboButton(c)) {
            return new Dimension(size.width + (MacIntelliJButtonUI.isComboButton(c) ? 8 : 16), 27);
        }
        return size;
    }

    @Override
    protected void paintDisabledText(Graphics g, String text, JComponent c, Rectangle textRect, FontMetrics metrics) {
        int x = textRect.x + this.getTextShiftOffset();
        int y = textRect.y + metrics.getAscent() + this.getTextShiftOffset();
        if (MacIntelliJButtonUI.isDefaultButton(c)) {
            g.setColor((Color)Gray.xCC);
        } else {
            g.setColor(UIManager.getColor("Button.disabledText"));
        }
        SwingUtilities2.drawStringUnderlineCharAt(c, g, text, -1, x, y);
    }
}

