/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal;

import com.intellij.util.containers.MultiMap;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collection;
import java.util.Map;

public class DupIconsFinder {
    private static final MultiMap<Integer, String> hashes = new MultiMap();
    private static int totalClusters = 0;
    private static int totalDups = 0;

    public static void main(String[] args) throws Exception {
        File root = new File("/Users/max/images/icons");
        DupIconsFinder.processDir(root);
        for (Map.Entry entry : hashes.entrySet()) {
            DupIconsFinder.printDups((Collection)entry.getValue());
        }
        System.out.println("Total: " + totalDups + " files duplicated in " + totalClusters + " clusters");
    }

    private static void processDir(File root) throws Exception {
        File[] files = root.listFiles();
        if (files != null) {
            for (File file2 : files) {
                if (file2.isFile() && file2.getName().endsWith(".png")) {
                    DupIconsFinder.processFile(file2.getPath());
                    continue;
                }
                if (!file2.isDirectory()) continue;
                DupIconsFinder.processDir(file2);
            }
        }
    }

    private static void printDups(Collection<String> files) {
        if (files.size() > 1) {
            System.out.println("Duplicate " + files.size() + " files");
            for (String file2 : files) {
                System.out.println(file2);
                ++totalDups;
            }
            ++totalClusters;
            System.out.println();
        }
    }

    private static void processFile(String path) throws Exception {
        int b;
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(path));
        int hc = 0;
        while ((b = ((InputStream)stream).read()) != -1) {
            hc = hc * 31 + b;
        }
        hashes.putValue((Object)hc, (Object)path);
        ((InputStream)stream).close();
    }
}

