/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jps.impl;

import com.intellij.jps.impl.JpsPluginBean;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.ExtensionPointListener;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.extensions.ExtensionsArea;
import com.intellij.openapi.extensions.PluginDescriptor;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.plugin.JpsPluginManager;

public class JpsIdePluginManagerImpl
extends JpsPluginManager {
    private List<PluginDescriptor> myExternalBuildPlugins = new CopyOnWriteArrayList<PluginDescriptor>();

    public JpsIdePluginManagerImpl() {
        ExtensionsArea rootArea = Extensions.getRootArea();
        if (rootArea.hasExtensionPoint(JpsPluginBean.EP_NAME.getName())) {
            rootArea.getExtensionPoint(JpsPluginBean.EP_NAME).addExtensionPointListener((ExtensionPointListener)new ExtensionPointListener<JpsPluginBean>(){

                public void extensionAdded(@NotNull JpsPluginBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$1", "extensionAdded"));
                    }
                    ContainerUtil.addIfNotNull((Object)pluginDescriptor, (Collection)JpsIdePluginManagerImpl.this.myExternalBuildPlugins);
                }

                public void extensionRemoved(@NotNull JpsPluginBean extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$1", "extensionRemoved"));
                    }
                }
            });
        }
        if (rootArea.hasExtensionPoint("com.intellij.compileServer.plugin")) {
            ExtensionPoint extensionPoint = rootArea.getExtensionPoint("com.intellij.compileServer.plugin");
            extensionPoint.addExtensionPointListener(new ExtensionPointListener(){

                public void extensionAdded(@NotNull Object extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$2", "extensionAdded"));
                    }
                    ContainerUtil.addIfNotNull((Object)pluginDescriptor, (Collection)JpsIdePluginManagerImpl.this.myExternalBuildPlugins);
                }

                public void extensionRemoved(@NotNull Object extension, @Nullable PluginDescriptor pluginDescriptor) {
                    if (extension == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/jps/impl/JpsIdePluginManagerImpl$2", "extensionRemoved"));
                    }
                }
            });
        }
    }

    @NotNull
    public <T> Collection<T> loadExtensions(@NotNull Class<T> extensionClass) {
        if (extensionClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extensionClass", "com/intellij/jps/impl/JpsIdePluginManagerImpl", "loadExtensions"));
        }
        String resourceName = "META-INF/services/" + extensionClass.getName();
        LinkedHashSet<Class<T>> classes = new LinkedHashSet<Class<T>>();
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        for (PluginDescriptor pluginDescriptor : this.myExternalBuildPlugins) {
            ContainerUtil.addIfNotNull(loaders, (Object)pluginDescriptor.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            loaders.add(((Object)((Object)this)).getClass().getClassLoader());
        }
        HashSet<String> loadedUrls = new HashSet<String>();
        for (ClassLoader loader : loaders) {
            try {
                Enumeration<URL> enumeration = loader.getResources(resourceName);
                while (enumeration.hasMoreElements()) {
                    URL url = enumeration.nextElement();
                    if (!loadedUrls.add(url.toExternalForm())) continue;
                    JpsIdePluginManagerImpl.loadImplementations(url, loader, classes);
                }
            }
            catch (IOException iOException) {
                throw new ServiceConfigurationError("Cannot load configuration files for " + extensionClass.getName(), iOException);
            }
        }
        ArrayList<T> arrayList = new ArrayList<T>();
        for (Class clazz : classes) {
            try {
                arrayList.add(extensionClass.cast(clazz.newInstance()));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("Class " + clazz.getName() + " cannot be instantiated", e);
            }
        }
        ArrayList<T> arrayList2 = arrayList;
        if (arrayList2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jps/impl/JpsIdePluginManagerImpl", "loadExtensions"));
        }
        return arrayList2;
    }

    private static <T> void loadImplementations(URL url, ClassLoader loader, Set<Class<T>> result) throws IOException {
        for (String name : JpsIdePluginManagerImpl.loadClassNames(url)) {
            try {
                result.add(Class.forName(name, false, loader));
            }
            catch (ClassNotFoundException e) {
                throw new ServiceConfigurationError("Cannot find class " + name, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> loadClassNames(URL url) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream(), "UTF-8"));){
            String line;
            while ((line = in.readLine()) != null) {
                int i = line.indexOf(35);
                if (i >= 0) {
                    line = line.substring(0, i);
                }
                if ((line = line.trim()).isEmpty()) continue;
                result.add(line);
            }
        }
        return result;
    }
}

