/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.Icon;
import javax.swing.JComponent;

public class IdeaActionButtonLook
extends ActionButtonLook {
    private static final Color ALPHA_20 = Gray._0.withAlpha(20);
    private static final Color ALPHA_30 = Gray._0.withAlpha(30);
    private static final Color ALPHA_40 = Gray._0.withAlpha(40);
    private static final Color ALPHA_120 = Gray._0.withAlpha(120);
    private static final BasicStroke BASIC_STROKE = new BasicStroke();

    @Override
    public void paintBackground(Graphics g, JComponent component, int state) {
        if (state != 0) {
            Component opaque = UIUtil.findNearestOpaque((Component)component);
            Color bg = opaque != null ? opaque.getBackground() : null;
            this.paintBackground(g, component.getSize(), bg, state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintBackground(Graphics g, Dimension size, Color background, int state) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        try {
            Color bg;
            Color color = bg = background == null ? JBColor.background() : background;
            if (UIUtil.isUnderAquaLookAndFeel() || SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
                if (state == -1) {
                    if (UIUtil.isUnderAquaLookAndFeel()) {
                        ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)ALPHA_40, (float)size.width, (float)size.height, (Color)ALPHA_20));
                        ((Graphics2D)g).fill(IdeaActionButtonLook.getShape(size));
                        g.setColor(ALPHA_30);
                        ((Graphics2D)g).draw(IdeaActionButtonLook.getShape(size));
                    } else {
                        g.setColor(ColorUtil.darker((Color)bg, (int)1));
                        ((Graphics2D)g).fill(IdeaActionButtonLook.getShape(size));
                        g.setColor((Color)Gray.xC0);
                        ((Graphics2D)g).draw(IdeaActionButtonLook.getShape(size));
                    }
                } else if (state == 1) {
                    if (UIUtil.isUnderAquaLookAndFeel()) {
                        ((Graphics2D)g).setPaint(UIUtil.getGradientPaint((float)0.0f, (float)0.0f, (Color)bg, (float)0.0f, (float)size.height, (Color)ColorUtil.darker((Color)bg, (int)2)));
                        ((Graphics2D)g).fill(IdeaActionButtonLook.getShape(size));
                    } else {
                        ((Graphics2D)g).setPaint(ColorUtil.darker((Color)bg, (int)1));
                        ((Graphics2D)g).fill(IdeaActionButtonLook.getShape(size));
                        g.setColor((Color)Gray.xCC);
                        ((Graphics2D)g).draw(IdeaActionButtonLook.getShape(size));
                    }
                }
            } else {
                boolean dark = UIUtil.isUnderDarcula();
                g.setColor(state == -1 ? ColorUtil.shift((Color)bg, (double)(dark ? 1.4285714285714286 : 0.7)) : (dark ? Gray._255.withAlpha(40) : ALPHA_40));
                ((Graphics2D)g).fill(IdeaActionButtonLook.getShape(size));
            }
        }
        finally {
            config.restore();
        }
    }

    @Override
    public void paintBorder(Graphics g, JComponent component, int state) {
        if (state != 0) {
            this.paintBorder(g, component.getSize(), state);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintBorder(Graphics g, Dimension size, int state) {
        GraphicsConfig config = GraphicsUtil.setupAAPainting((Graphics)g);
        try {
            if (UIUtil.isUnderAquaLookAndFeel()) {
                if (state == 1) {
                    g.setColor((Color)JBColor.GRAY);
                    ((Graphics2D)g).draw(IdeaActionButtonLook.getShape(size));
                }
            } else if (SystemInfo.isMac && UIUtil.isUnderIntelliJLaF()) {
            } else {
                double shift = UIUtil.isUnderDarcula() ? 2.0408163265306123 : 0.49;
                g.setColor(ColorUtil.shift((Color)UIUtil.getPanelBackground(), (double)shift));
                ((Graphics2D)g).setStroke(BASIC_STROKE);
                ((Graphics2D)g).draw(IdeaActionButtonLook.getShape(size));
            }
        }
        finally {
            config.restore();
        }
    }

    private static Shape getShape(Dimension size) {
        return new RoundRectangle2D.Double(1.0, 1.0, size.width - 3, size.height - 3, 4.0, 4.0);
    }

    @Override
    public void paintIcon(Graphics g, ActionButtonComponent actionButton, Icon icon) {
        int width = icon.getIconWidth();
        int height = icon.getIconHeight();
        int x = (int)Math.ceil((actionButton.getWidth() - width) / 2);
        int y = (int)Math.ceil((actionButton.getHeight() - height) / 2);
        this.paintIconAt(g, actionButton, icon, x, y);
    }

    @Override
    public void paintIconAt(Graphics g, ActionButtonComponent button, Icon icon, int x, int y) {
        icon.paintIcon(null, g, x, y);
    }
}

