/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.command.impl;

import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.UndoableAction;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NotNull;

class NonUndoableAction
implements UndoableAction {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.command.undo.NonUndoableAction");
    private final DocumentReference[] myRefs;
    private final boolean myGlobal;

    protected NonUndoableAction(@NotNull DocumentReference ref, boolean isGlobal) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "com/intellij/openapi/command/impl/NonUndoableAction", "<init>"));
        }
        this.myGlobal = isGlobal;
        this.myRefs = new DocumentReference[]{ref};
        if (LOG.isDebugEnabled()) {
            LOG.debug("global=" + isGlobal + "; doc=" + ref, new Throwable());
        }
    }

    public final void undo() {
        LOG.error("Cannot undo");
    }

    public void redo() {
        LOG.error("Cannot redo");
    }

    public DocumentReference[] getAffectedDocuments() {
        return this.myRefs;
    }

    public boolean isGlobal() {
        return this.myGlobal;
    }
}

