/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.store;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ReadOnlyModificationException
extends RuntimeException {
    private final VirtualFile myFile;
    private final StateStorage.SaveSession mySession;

    public ReadOnlyModificationException(@NotNull VirtualFile file2, @Nullable Throwable cause, StateStorage.SaveSession session) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/components/store/ReadOnlyModificationException", "<init>"));
        }
        super(cause);
        this.myFile = file2;
        this.mySession = session;
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/store/ReadOnlyModificationException", "getFile"));
        }
        return virtualFile;
    }

    @Nullable
    public StateStorage.SaveSession getSession() {
        return this.mySession;
    }
}

