/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PreloadableAction;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diff.DiffBundle;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffManager;
import com.intellij.openapi.diff.DiffRequest;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

@Deprecated
abstract class BaseDiffAction
extends AnAction
implements PreloadableAction,
DumbAware {
    BaseDiffAction() {
    }

    public void actionPerformed(AnActionEvent e) {
        DiffRequest diffData = this.getDiffData(e.getDataContext());
        if (diffData == null) {
            return;
        }
        final DiffContent[] contents = diffData.getContents();
        final FileDocumentManager documentManager = FileDocumentManager.getInstance();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                for (DiffContent content : contents) {
                    Document document = content.getDocument();
                    if (document == null) continue;
                    documentManager.saveDocument(document);
                }
            }
        });
        DiffManager.getInstance().getDiffTool().show(diffData);
    }

    public void update(AnActionEvent e) {
        DiffRequest diffData = this.getDiffData(e.getDataContext());
        boolean enabled = diffData != null && (!diffData.isSafeToCallFromUpdate() || diffData.getContents() != null && DiffManager.getInstance().getDiffTool().canShow(diffData));
        Presentation presentation = e.getPresentation();
        presentation.setEnabled(enabled);
        if (enabled) {
            presentation.setVisible(true);
        } else {
            this.disableAction(presentation);
        }
    }

    protected void disableAction(Presentation presentation) {
    }

    @Nullable
    protected abstract DiffRequest getDiffData(DataContext var1);

    protected static VirtualFile getDocumentFile(Document document) {
        return FileDocumentManager.getInstance().getFile(document);
    }

    protected static boolean isEditorContent(Document document) {
        VirtualFile editorFile = BaseDiffAction.getDocumentFile(document);
        return editorFile == null || !editorFile.isValid();
    }

    protected static String getDocumentFileUrl(Document document) {
        return BaseDiffAction.getDocumentFile(document).getPresentableUrl();
    }

    protected static String getContentTitle(Document document) {
        VirtualFile editorFile = BaseDiffAction.getDocumentFile(document);
        if (editorFile == null || !editorFile.isValid()) {
            return DiffBundle.message((String)"diff.content.editor.content.title", (Object[])new Object[0]);
        }
        return editorFile.getPresentableUrl();
    }

    protected static String getVirtualFileContentTitle(VirtualFile documentFile) {
        String name = documentFile.getName();
        VirtualFile parent = documentFile.getParent();
        if (parent != null) {
            return name + " (" + FileUtil.toSystemDependentName((String)parent.getPath()) + ")";
        }
        return name;
    }

    public void preload() {
        if (!ApplicationManager.getApplication().isDisposed()) {
            DiffManager.getInstance();
        }
    }
}

