/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.actions;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlipCommaIntention
implements IntentionAction {
    @NotNull
    public String getText() {
        String string = this.getFamilyName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/FlipCommaIntention", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if ("Flip ','" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/actions/FlipCommaIntention", "getFamilyName"));
        }
        return "Flip ','";
    }

    public boolean isAvailable(@NotNull Project project2, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "isAvailable"));
        }
        PsiElement comma = FlipCommaIntention.currentCommaElement(editor, file2);
        return comma != null && FlipCommaIntention.smartAdvanceAsExpr(comma, true) != null && FlipCommaIntention.smartAdvance(comma, false) != null;
    }

    public void invoke(@NotNull Project project2, final @NotNull Editor editor, @NotNull PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "invoke"));
        }
        final PsiElement element = FlipCommaIntention.currentCommaElement(editor, file2);
        if (element != null) {
            new WriteCommandAction(project2, new PsiFile[]{file2}){

                protected void run(@NotNull Result result) throws Throwable {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/editor/actions/FlipCommaIntention$1", "run"));
                    }
                    PostprocessReformattingAspect.getInstance(this.getProject()).disablePostprocessFormattingInside(new Runnable(){

                        @Override
                        public void run() {
                            FlipCommaIntention.swapAtComma(editor, element);
                        }
                    });
                }
            }.execute();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }

    private static void swapAtComma(@NotNull Editor editor, @NotNull PsiElement comma) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "swapAtComma"));
        }
        if (comma == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "comma", "com/intellij/openapi/editor/actions/FlipCommaIntention", "swapAtComma"));
        }
        PsiElement prev = FlipCommaIntention.smartAdvanceAsExpr(comma, false);
        PsiElement next = FlipCommaIntention.smartAdvanceAsExpr(comma, true);
        if (prev != null && next != null) {
            boolean caretBeforeComma = editor.getCaretModel().getOffset() <= comma.getTextRange().getStartOffset();
            PsiElement nextAnchor = next.getPrevSibling();
            PsiElement prevAnchor = prev.getNextSibling();
            comma.getParent().addBefore(next, prevAnchor);
            comma.getParent().addAfter(prev, nextAnchor);
            next.delete();
            prev.delete();
            editor.getCaretModel().moveToOffset(caretBeforeComma ? comma.getTextRange().getStartOffset() : comma.getTextRange().getEndOffset());
        }
    }

    private static PsiElement currentCommaElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "currentCommaElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "currentCommaElement"));
        }
        PsiElement element = FlipCommaIntention.leftElement(editor, file2);
        if (!FlipCommaIntention.isComma(element) && !FlipCommaIntention.isComma(element = FlipCommaIntention.rightElement(editor, file2))) {
            return null;
        }
        return element;
    }

    @Nullable
    private static PsiElement leftElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "leftElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "leftElement"));
        }
        return file2.findElementAt(editor.getCaretModel().getOffset() - 1);
    }

    @Nullable
    private static PsiElement rightElement(@NotNull Editor editor, @NotNull PsiFile file2) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/editor/actions/FlipCommaIntention", "rightElement"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/editor/actions/FlipCommaIntention", "rightElement"));
        }
        return file2.findElementAt(editor.getCaretModel().getOffset());
    }

    private static boolean isComma(@Nullable PsiElement element) {
        return element != null && element.getText().equals(",");
    }

    @Nullable
    private static PsiElement smartAdvance(PsiElement element, boolean fwd) {
        Class[] skipTypes = new Class[]{PsiWhiteSpace.class, PsiComment.class};
        return fwd ? PsiTreeUtil.skipSiblingsForward((PsiElement)element, (Class[])skipTypes) : PsiTreeUtil.skipSiblingsBackward((PsiElement)element, (Class[])skipTypes);
    }

    @Nullable
    private static PsiElement smartAdvanceAsExpr(PsiElement element, boolean fwd) {
        return (PsiElement)ObjectUtils.tryCast((Object)FlipCommaIntention.smartAdvance(element, fwd), PsiElement.class);
    }
}

