/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.richcopy.settings;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.util.xmlb.XmlSerializerUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="EditorRichCopySettings", storages={@Storage(value="editor.rich.copy.xml")})
public class RichCopySettings
implements PersistentStateComponent<RichCopySettings> {
    @NotNull
    public static final String ACTIVE_GLOBAL_SCHEME_MARKER = "__ACTIVE_GLOBAL_SCHEME__";
    private boolean myEnabled = true;
    private String mySchemeName = "__ACTIVE_GLOBAL_SCHEME__";

    @NotNull
    public static RichCopySettings getInstance() {
        RichCopySettings richCopySettings = (RichCopySettings)ServiceManager.getService(RichCopySettings.class);
        if (richCopySettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/settings/RichCopySettings", "getInstance"));
        }
        return richCopySettings;
    }

    @NotNull
    public EditorColorsScheme getColorsScheme(@NotNull EditorColorsScheme editorColorsScheme) {
        if (editorColorsScheme == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorColorsScheme", "com/intellij/openapi/editor/richcopy/settings/RichCopySettings", "getColorsScheme"));
        }
        EditorColorsScheme result = null;
        if (this.mySchemeName != null && !ACTIVE_GLOBAL_SCHEME_MARKER.equals(this.mySchemeName)) {
            result = EditorColorsManager.getInstance().getScheme(this.mySchemeName);
        }
        EditorColorsScheme editorColorsScheme2 = result == null ? editorColorsScheme : result;
        if (editorColorsScheme2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/settings/RichCopySettings", "getColorsScheme"));
        }
        return editorColorsScheme2;
    }

    @Nullable
    public RichCopySettings getState() {
        return this;
    }

    public void loadState(RichCopySettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
    }

    @NotNull
    public String getSchemeName() {
        String string = this.mySchemeName == null ? ACTIVE_GLOBAL_SCHEME_MARKER : this.mySchemeName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/editor/richcopy/settings/RichCopySettings", "getSchemeName"));
        }
        return string;
    }

    public void setSchemeName(@Nullable String schemeName) {
        this.mySchemeName = schemeName;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }
}

