/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification;

import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.ide.errorTreeView.ErrorTreeElementKind;
import com.intellij.ide.errorTreeView.ErrorViewStructure;
import com.intellij.ide.errorTreeView.GroupingElement;
import com.intellij.ide.errorTreeView.NewEditableErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.LocationAwareExternalSystemException;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.notification.EditableNotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.ExternalSystemNotificationExtension;
import com.intellij.openapi.externalSystem.service.notification.MessageCounter;
import com.intellij.openapi.externalSystem.service.notification.NotificationCategory;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.externalSystem.service.notification.NotificationMessageElement;
import com.intellij.openapi.externalSystem.service.notification.NotificationSource;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemBundle;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsView;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewImpl;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NonNavigatable;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.SequentialTaskExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.PooledThreadExecutor;

public class ExternalSystemNotificationManager
implements Disposable {
    @NotNull
    private static final Key<Pair<NotificationSource, ProjectSystemId>> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    @NotNull
    private final SequentialTaskExecutor myUpdater;
    @NotNull
    private final Project myProject;
    @NotNull
    private final Set<Notification> myNotifications;
    @NotNull
    private final Set<ProjectSystemId> initializedExternalSystem;
    @NotNull
    private final MessageCounter myMessageCounter;

    public ExternalSystemNotificationManager(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "<init>"));
        }
        this.myUpdater = new SequentialTaskExecutor((Executor)PooledThreadExecutor.INSTANCE);
        this.myProject = project2;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.myNotifications = ContainerUtil.newConcurrentSet();
        this.initializedExternalSystem = ContainerUtil.newConcurrentSet();
        this.myMessageCounter = new MessageCounter();
    }

    @NotNull
    public static ExternalSystemNotificationManager getInstance(@NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getInstance"));
        }
        ExternalSystemNotificationManager externalSystemNotificationManager = (ExternalSystemNotificationManager)ServiceManager.getService((Project)project2, ExternalSystemNotificationManager.class);
        if (externalSystemNotificationManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getInstance"));
        }
        return externalSystemNotificationManager;
    }

    public void processExternalProjectRefreshError(@NotNull Throwable error, @NotNull String externalProjectName, @NotNull ProjectSystemId externalSystemId) {
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "processExternalProjectRefreshError"));
        }
        if (externalProjectName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalProjectName", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "processExternalProjectRefreshError"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "processExternalProjectRefreshError"));
        }
        if (this.myProject.isDisposed() || !this.myProject.isOpen()) {
            return;
        }
        ExternalSystemManager manager = ExternalSystemApiUtil.getManager((ProjectSystemId)externalSystemId);
        if (!(manager instanceof ExternalSystemConfigurableAware)) {
            return;
        }
        String title = ExternalSystemBundle.message((String)"notification.project.refresh.fail.title", (Object[])new Object[]{externalSystemId.getReadableName(), externalProjectName});
        String message = ExternalSystemApiUtil.buildErrorMessage((Throwable)error);
        NotificationCategory notificationCategory = NotificationCategory.ERROR;
        String filePath = null;
        Integer line = null;
        Integer column = null;
        Throwable unwrapped = RemoteUtil.unwrap((Throwable)error);
        if (unwrapped instanceof LocationAwareExternalSystemException) {
            LocationAwareExternalSystemException locationAwareExternalSystemException = (LocationAwareExternalSystemException)unwrapped;
            filePath = locationAwareExternalSystemException.getFilePath();
            line = locationAwareExternalSystemException.getLine();
            column = locationAwareExternalSystemException.getColumn();
        }
        NotificationData notificationData = new NotificationData(title, message, notificationCategory, NotificationSource.PROJECT_SYNC, filePath, (Integer)ObjectUtils.notNull((Object)line, (Object)-1), (Integer)ObjectUtils.notNull((Object)column, (Object)-1), false);
        for (ExternalSystemNotificationExtension extension : (ExternalSystemNotificationExtension[])ExternalSystemNotificationExtension.EP_NAME.getExtensions()) {
            ProjectSystemId targetExternalSystemId = extension.getTargetExternalSystemId();
            if (!externalSystemId.equals((Object)targetExternalSystemId) && !targetExternalSystemId.equals((Object)ProjectSystemId.IDE)) continue;
            extension.customize(notificationData, this.myProject, error);
        }
        EditorNotifications.getInstance((Project)this.myProject).updateAllNotifications();
        this.showNotification(externalSystemId, notificationData);
    }

    public void showNotification(final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationData notificationData) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "showNotification"));
        }
        if (notificationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationData", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "showNotification"));
        }
        this.myUpdater.submit(new Runnable(){

            @Override
            public void run() {
                if (ExternalSystemNotificationManager.this.myProject.isDisposed()) {
                    return;
                }
                final Application app = ApplicationManager.getApplication();
                Runnable action = new Runnable(){

                    @Override
                    public void run() {
                        NotificationGroup group;
                        if (!ExternalSystemNotificationManager.this.initializedExternalSystem.contains(externalSystemId)) {
                            app.runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    if (ExternalSystemNotificationManager.this.myProject.isDisposed()) {
                                        return;
                                    }
                                    ExternalSystemUtil.ensureToolWindowContentInitialized(ExternalSystemNotificationManager.this.myProject, externalSystemId);
                                    ExternalSystemNotificationManager.this.initializedExternalSystem.add(externalSystemId);
                                }
                            });
                        }
                        if (ExternalSystemNotificationManager.this.myProject.isDisposed()) {
                            return;
                        }
                        if (notificationData.getBalloonGroup() == null) {
                            ExternalProjectsView externalProjectsView = ExternalProjectsManager.getInstance(ExternalSystemNotificationManager.this.myProject).getExternalProjectsView(externalSystemId);
                            group = externalProjectsView instanceof ExternalProjectsViewImpl ? ((ExternalProjectsViewImpl)externalProjectsView).getNotificationGroup() : null;
                        } else {
                            NotificationGroup registeredGroup = NotificationGroup.findRegisteredGroup((String)notificationData.getBalloonGroup());
                            NotificationGroup notificationGroup = group = registeredGroup != null ? registeredGroup : NotificationGroup.balloonGroup((String)notificationData.getBalloonGroup());
                        }
                        if (group == null) {
                            return;
                        }
                        Notification notification = group.createNotification(notificationData.getTitle(), notificationData.getMessage(), notificationData.getNotificationCategory().getNotificationType(), notificationData.getListener());
                        ExternalSystemNotificationManager.this.myNotifications.add(notification);
                        if (notificationData.isBalloonNotification()) {
                            ExternalSystemNotificationManager.this.applyNotification(notification);
                        } else {
                            ExternalSystemNotificationManager.this.addMessage(notification, externalSystemId, notificationData);
                        }
                    }
                };
                app.invokeLater(action, ModalityState.defaultModalityState(), ExternalSystemNotificationManager.this.myProject.getDisposed());
            }
        });
    }

    public void openMessageView(final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationSource notificationSource) {
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "openMessageView"));
        }
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "openMessageView"));
        }
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                ExternalSystemNotificationManager.this.prepareMessagesView(externalSystemId, notificationSource, true);
            }
        });
    }

    public void clearNotifications(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "clearNotifications"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "clearNotifications"));
        }
        this.clearNotifications(null, notificationSource, externalSystemId);
    }

    public void clearNotifications(final @Nullable String groupName, final @NotNull NotificationSource notificationSource, final @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "clearNotifications"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "clearNotifications"));
        }
        this.myMessageCounter.remove(groupName, notificationSource, externalSystemId);
        this.myUpdater.submit(new Runnable(){

            @Override
            public void run() {
                if (ExternalSystemNotificationManager.this.myProject.isDisposed()) {
                    return;
                }
                Iterator iterator = ExternalSystemNotificationManager.this.myNotifications.iterator();
                while (iterator.hasNext()) {
                    Notification notification = (Notification)iterator.next();
                    if (groupName != null && !groupName.equals(notification.getGroupId())) continue;
                    notification.expire();
                    iterator.remove();
                }
                ToolWindow toolWindow = ToolWindowManager.getInstance((Project)ExternalSystemNotificationManager.this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
                if (toolWindow == null) {
                    return;
                }
                final Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
                final MessageView messageView = (MessageView)ServiceManager.getService((Project)ExternalSystemNotificationManager.this.myProject, MessageView.class);
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (ExternalSystemNotificationManager.this.myProject.isDisposed()) {
                            return;
                        }
                        for (Content content : messageView.getContentManager().getContents()) {
                            if (content.isPinned() || !contentIdPair.equals(content.getUserData(CONTENT_ID_KEY))) continue;
                            if (groupName == null) {
                                messageView.getContentManager().removeContent(content, true);
                                continue;
                            }
                            assert (content.getComponent() instanceof NewEditableErrorTreeViewPanel);
                            NewEditableErrorTreeViewPanel errorTreeView = (NewEditableErrorTreeViewPanel)content.getComponent();
                            ErrorViewStructure errorViewStructure = errorTreeView.getErrorViewStructure();
                            errorViewStructure.removeGroup(groupName);
                        }
                    }
                });
            }
        });
    }

    public int getMessageCount(@NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getMessageCount"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getMessageCount"));
        }
        return this.getMessageCount(null, notificationSource, notificationCategory, externalSystemId);
    }

    public int getMessageCount(@Nullable String groupName, @NotNull NotificationSource notificationSource, @Nullable NotificationCategory notificationCategory, @NotNull ProjectSystemId externalSystemId) {
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getMessageCount"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getMessageCount"));
        }
        return this.myMessageCounter.getCount(groupName, notificationSource, notificationCategory, externalSystemId);
    }

    private void addMessage(final @NotNull Notification notification, final @NotNull ProjectSystemId externalSystemId, final @NotNull NotificationData notificationData) {
        int guiColumn;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "addMessage"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "addMessage"));
        }
        if (notificationData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationData", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "addMessage"));
        }
        final VirtualFile virtualFile = notificationData.getFilePath() != null ? ExternalSystemUtil.findLocalFileByPath(notificationData.getFilePath()) : null;
        final String groupName = virtualFile != null ? virtualFile.getPresentableUrl() : notificationData.getTitle();
        this.myMessageCounter.increment(groupName, notificationData.getNotificationSource(), notificationData.getNotificationCategory(), externalSystemId);
        int line = notificationData.getLine() - 1;
        int column = notificationData.getColumn() - 1;
        if (virtualFile == null) {
            column = -1;
            line = -1;
        }
        int guiLine = line < 0 ? -1 : line + 1;
        int n = guiColumn = column < 0 ? 0 : column + 1;
        final Navigatable navigatable = notificationData.getNavigatable() != null ? notificationData.getNavigatable() : (virtualFile != null ? new OpenFileDescriptor(this.myProject, virtualFile, line, column) : NonNavigatable.INSTANCE);
        final ErrorTreeElementKind kind = ErrorTreeElementKind.convertMessageFromCompilerErrorType((int)notificationData.getNotificationCategory().getMessageCategory());
        final String[] message = notificationData.getMessage().split("\n");
        final String exportPrefix = NewErrorTreeViewPanel.createExportPrefix(guiLine);
        final String rendererPrefix = NewErrorTreeViewPanel.createRendererPrefix(guiLine, guiColumn);
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

            @Override
            public void run() {
                boolean activate = notificationData.getNotificationCategory() == NotificationCategory.ERROR || notificationData.getNotificationCategory() == NotificationCategory.WARNING;
                NewErrorTreeViewPanel errorTreeView = ExternalSystemNotificationManager.this.prepareMessagesView(externalSystemId, notificationData.getNotificationSource(), activate);
                GroupingElement groupingElement = errorTreeView.getErrorViewStructure().getGroupingElement(groupName, null, virtualFile);
                NotificationMessageElement navigatableMessageElement = notificationData.hasLinks() ? new EditableNotificationMessageElement(notification, kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix) : new NotificationMessageElement(kind, groupingElement, message, navigatable, exportPrefix, rendererPrefix);
                errorTreeView.getErrorViewStructure().addNavigatableMessage(groupName, navigatableMessageElement);
                errorTreeView.updateTree();
            }
        });
    }

    private void applyNotification(@NotNull Notification notification) {
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "applyNotification"));
        }
        if (!this.myProject.isDisposed() && this.myProject.isOpen()) {
            notification.notify(this.myProject);
        }
    }

    @NotNull
    public NewErrorTreeViewPanel prepareMessagesView(@NotNull ProjectSystemId externalSystemId, @NotNull NotificationSource notificationSource, boolean activateView) {
        NewEditableErrorTreeViewPanel errorTreeView;
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "prepareMessagesView"));
        }
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "prepareMessagesView"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String contentDisplayName = ExternalSystemNotificationManager.getContentDisplayName(notificationSource, externalSystemId);
        Pair contentIdPair = Pair.create((Object)((Object)notificationSource), (Object)externalSystemId);
        Content targetContent = this.findContent((Pair<NotificationSource, ProjectSystemId>)contentIdPair, contentDisplayName);
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        if (targetContent == null || !contentIdPair.equals(targetContent.getUserData(CONTENT_ID_KEY))) {
            errorTreeView = new NewEditableErrorTreeViewPanel(this.myProject, null, true, true, null);
            targetContent = ContentFactory.SERVICE.getInstance().createContent((JComponent)errorTreeView, contentDisplayName, true);
            targetContent.putUserData(CONTENT_ID_KEY, (Object)contentIdPair);
            messageView.getContentManager().addContent(targetContent);
            Disposer.register((Disposable)targetContent, (Disposable)errorTreeView);
        } else {
            assert (targetContent.getComponent() instanceof NewEditableErrorTreeViewPanel);
            errorTreeView = (NewEditableErrorTreeViewPanel)targetContent.getComponent();
        }
        messageView.getContentManager().setSelectedContent(targetContent);
        ToolWindow tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW);
        if (activateView && tw != null && !tw.isActive()) {
            tw.activate(null, false);
        }
        NewEditableErrorTreeViewPanel newEditableErrorTreeViewPanel = errorTreeView;
        if (newEditableErrorTreeViewPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "prepareMessagesView"));
        }
        return newEditableErrorTreeViewPanel;
    }

    @Nullable
    private Content findContent(@NotNull Pair<NotificationSource, ProjectSystemId> contentIdPair, @NotNull String contentDisplayName) {
        if (contentIdPair == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentIdPair", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "findContent"));
        }
        if (contentDisplayName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentDisplayName", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "findContent"));
        }
        Content targetContent = null;
        MessageView messageView = (MessageView)ServiceManager.getService((Project)this.myProject, MessageView.class);
        for (Content content : messageView.getContentManager().getContents()) {
            if (!contentIdPair.equals(content.getUserData(CONTENT_ID_KEY)) || !StringUtil.equals((CharSequence)content.getDisplayName(), (CharSequence)contentDisplayName) || content.isPinned()) continue;
            targetContent = content;
        }
        return targetContent;
    }

    @NotNull
    public static String getContentDisplayName(@NotNull NotificationSource notificationSource, @NotNull ProjectSystemId externalSystemId) {
        String contentDisplayName;
        if (notificationSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notificationSource", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getContentDisplayName"));
        }
        if (externalSystemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "externalSystemId", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getContentDisplayName"));
        }
        switch (notificationSource) {
            case PROJECT_SYNC: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.project.sync.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            case TASK_EXECUTION: {
                contentDisplayName = ExternalSystemBundle.message((String)"notification.messages.task.execution.tab.name", (Object[])new Object[]{externalSystemId.getReadableName()});
                break;
            }
            default: {
                throw new AssertionError((Object)("unsupported notification source found: " + (Object)((Object)notificationSource)));
            }
        }
        String string = contentDisplayName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/notification/ExternalSystemNotificationManager", "getContentDisplayName"));
        }
        return string;
    }

    public void dispose() {
        this.myNotifications.clear();
        this.initializedExternalSystem.clear();
    }
}

