/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.notification.callback;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.externalSystem.ExternalSystemConfigurableAware;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalSystemConfigurable;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OpenExternalSystemSettingsCallback
extends NotificationListener.Adapter {
    public static final String ID = "#open_external_system_settings";
    private final Project myProject;
    @NotNull
    private final ProjectSystemId mySystemId;
    @Nullable
    private final String myLinkedProjectPath;

    public OpenExternalSystemSettingsCallback(Project project2, @NotNull ProjectSystemId systemId) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/notification/callback/OpenExternalSystemSettingsCallback", "<init>"));
        }
        this(project2, systemId, null);
    }

    public OpenExternalSystemSettingsCallback(Project project2, @NotNull ProjectSystemId systemId, @Nullable String linkedProjectPath) {
        if (systemId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "systemId", "com/intellij/openapi/externalSystem/service/notification/callback/OpenExternalSystemSettingsCallback", "<init>"));
        }
        this.myProject = project2;
        this.mySystemId = systemId;
        this.myLinkedProjectPath = linkedProjectPath;
    }

    protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
        ExternalSystemManager manager;
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/intellij/openapi/externalSystem/service/notification/callback/OpenExternalSystemSettingsCallback", "hyperlinkActivated"));
        }
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/externalSystem/service/notification/callback/OpenExternalSystemSettingsCallback", "hyperlinkActivated"));
        }
        if (this.myLinkedProjectPath == null || !((manager = ExternalSystemApiUtil.getManager((ProjectSystemId)this.mySystemId)) instanceof ExternalSystemConfigurableAware)) {
            ShowSettingsUtil.getInstance().showSettingsDialog(this.myProject, this.mySystemId.getReadableName());
            return;
        }
        final Configurable configurable = ((ExternalSystemConfigurableAware)manager).getConfigurable(this.myProject);
        if (configurable instanceof AbstractExternalSystemConfigurable) {
            ShowSettingsUtil.getInstance().editConfigurable(this.myProject, configurable, new Runnable(){

                @Override
                public void run() {
                    ((AbstractExternalSystemConfigurable)configurable).selectProject(OpenExternalSystemSettingsCallback.this.myLinkedProjectPath);
                }
            });
        }
    }
}

