/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service.project.manage;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.DataNode;
import com.intellij.openapi.externalSystem.model.Key;
import com.intellij.openapi.externalSystem.model.ProjectKeys;
import com.intellij.openapi.externalSystem.model.project.ModuleDependencyData;
import com.intellij.openapi.externalSystem.model.project.OrderAware;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.externalSystem.service.project.manage.AbstractDependencyDataService;
import com.intellij.openapi.externalSystem.util.Order;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.impl.ModuleOrderEntryImpl;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Order(value=-2147483645)
public class ModuleDependencyDataService
extends AbstractDependencyDataService<ModuleDependencyData, ModuleOrderEntry> {
    private static final Logger LOG = Logger.getInstance((String)("#" + ModuleDependencyDataService.class.getName()));

    @NotNull
    public Key<ModuleDependencyData> getTargetDataKey() {
        Key key = ProjectKeys.MODULE_DEPENDENCY;
        if (key == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getTargetDataKey"));
        }
        return key;
    }

    @Override
    @NotNull
    public Class<ModuleOrderEntry> getOrderEntryType() {
        if (ModuleOrderEntry.class == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getOrderEntryType"));
        }
        return ModuleOrderEntry.class;
    }

    @Override
    protected String getOrderEntryName(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ModuleOrderEntry orderEntry) {
        String newName;
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getOrderEntryName"));
        }
        if (orderEntry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "orderEntry", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "getOrderEntryName"));
        }
        String moduleName = orderEntry.getModuleName();
        Module orderEntryModule = orderEntry.getModule();
        if (orderEntryModule != null && (newName = modelsProvider.getModifiableModuleModel().getNewName(orderEntryModule)) != null) {
            moduleName = newName;
        }
        return moduleName;
    }

    @Override
    protected Map<OrderEntry, OrderAware> importData(@NotNull Collection<DataNode<ModuleDependencyData>> toImport, @NotNull Module module2, @NotNull IdeModifiableModelsProvider modelsProvider) {
        if (toImport == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toImport", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        if (modelsProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modelsProvider", "com/intellij/openapi/externalSystem/service/project/manage/ModuleDependencyDataService", "importData"));
        }
        HashMap toRemove = ContainerUtilRt.newHashMap();
        LinkedHashMap orderEntryDataMap = ContainerUtil.newLinkedHashMap();
        for (OrderEntry entry : modelsProvider.getOrderEntries(module2)) {
            if (!(entry instanceof ModuleOrderEntry)) continue;
            ModuleOrderEntry e = (ModuleOrderEntry)entry;
            toRemove.put(Pair.create((Object)e.getModuleName(), (Object)e.getScope()), e);
        }
        HashSet processed2 = ContainerUtil.newHashSet();
        ModifiableRootModel modifiableRootModel = modelsProvider.getModifiableRootModel(module2);
        for (DataNode<ModuleDependencyData> dependencyNode : toImport) {
            ModuleOrderEntry orderEntry;
            ModuleDependencyData dependencyData = (ModuleDependencyData)dependencyNode.getData();
            if (processed2.contains(dependencyData)) continue;
            processed2.add(dependencyData);
            toRemove.remove(Pair.create((Object)dependencyData.getInternalName(), (Object)dependencyData.getScope()));
            String moduleName = dependencyData.getInternalName();
            Module ideDependencyModule = modelsProvider.findIdeModule(moduleName);
            if (module2.equals(ideDependencyModule)) continue;
            if (ideDependencyModule == null) {
                LOG.warn(String.format("Can't import module dependency for '%s' module. Reason: target module (%s) is not found at the ide", module2.getName(), dependencyData));
            }
            if ((orderEntry = modelsProvider.findIdeModuleDependency(dependencyData, module2)) == null) {
                orderEntry = ideDependencyModule == null ? modifiableRootModel.addInvalidModuleEntry(moduleName) : modifiableRootModel.addModuleOrderEntry(ideDependencyModule);
            }
            orderEntry.setScope(dependencyData.getScope());
            orderEntry.setExported(dependencyData.isExported());
            boolean productionOnTestDependency = dependencyData.isProductionOnTestDependency();
            if (orderEntry instanceof ModuleOrderEntryImpl) {
                ((ModuleOrderEntryImpl)orderEntry).setProductionOnTestDependency(productionOnTestDependency);
            } else if (productionOnTestDependency) {
                LOG.warn("Unable to set productionOnTestDependency for entry: " + orderEntry);
            }
            orderEntryDataMap.put(orderEntry, dependencyData);
        }
        if (!toRemove.isEmpty()) {
            this.removeData(toRemove.values(), module2, modelsProvider);
        }
        return orderEntryDataMap;
    }
}

