/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.options.ex;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableVisitor;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.CardLayoutPanel;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.GradientViewport;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.border.Border;

public class ConfigurableCardPanel
extends CardLayoutPanel<Configurable, Configurable, JComponent> {
    private static final Logger LOG = Logger.getInstance(ConfigurableCardPanel.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Configurable prepare(Configurable key) {
        long time = System.currentTimeMillis();
        try {
            ConfigurableWrapper.cast(Configurable.class, (UnnamedConfigurable)key);
        }
        catch (Exception unexpected) {
            LOG.error("cannot prepare configurable", (Throwable)unexpected);
        }
        finally {
            ConfigurableCardPanel.warn(key, "prepare", time);
        }
        return key;
    }

    @Override
    protected JComponent create(final Configurable configurable) {
        return configurable == null ? null : (JComponent)ApplicationManager.getApplication().runReadAction((Computable)new Computable<JComponent>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public JComponent compute() {
                JComponent component = null;
                long time = System.currentTimeMillis();
                try {
                    component = configurable.createComponent();
                }
                catch (Exception unexpected) {
                    LOG.error("cannot create configurable component", (Throwable)unexpected);
                }
                finally {
                    ConfigurableCardPanel.warn(configurable, "create", time);
                }
                if (component != null) {
                    ConfigurableCardPanel.reset(configurable);
                    if (ConfigurableWrapper.cast(MasterDetails.class, (UnnamedConfigurable)configurable) == null) {
                        if (ConfigurableWrapper.cast(Configurable.NoMargin.class, (UnnamedConfigurable)configurable) == null) {
                            if (!component.getClass().equals(JPanel.class)) {
                                JPanel panel = new JPanel(new BorderLayout());
                                panel.add("Center", component);
                                component = panel;
                            }
                            component.setBorder((Border)JBUI.Borders.empty((int)5, (int)10, (int)10, (int)10));
                        }
                        if (ConfigurableWrapper.cast(Configurable.NoScroll.class, (UnnamedConfigurable)configurable) == null) {
                            JScrollPane scroll = ScrollPaneFactory.createScrollPane(null, (boolean)true);
                            scroll.setViewport((JViewport)((Object)new GradientViewport(component, (Insets)JBUI.insetsTop((int)5), true)));
                            scroll.getVerticalScrollBar().setUnitIncrement(JBUI.scale((int)10));
                            component = scroll;
                        }
                    }
                }
                return component;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void dispose(Configurable configurable) {
        if (configurable != null) {
            long time = System.currentTimeMillis();
            try {
                configurable.disposeUIResources();
            }
            catch (Exception unexpected) {
                LOG.error("cannot dispose configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable, "dispose", time);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset(Configurable configurable) {
        if (configurable != null) {
            long time = System.currentTimeMillis();
            try {
                configurable.reset();
            }
            catch (Exception unexpected) {
                LOG.error("cannot reset configurable", (Throwable)unexpected);
            }
            finally {
                ConfigurableCardPanel.warn(configurable, "reset", time);
            }
        }
    }

    static void warn(Configurable configurable, String action, long time) {
        if (ApplicationManager.getApplication().isDispatchThread()) {
            time = System.currentTimeMillis() - time;
            int threshold = Registry.intValue((String)"ide.settings.configurable.loading.threshold", (int)0);
            if (0 < threshold && (long)threshold < time) {
                String name = configurable.getDisplayName();
                String id = ConfigurableVisitor.ByID.getID(configurable);
                LOG.warn(String.valueOf(time) + " ms to " + action + " '" + name + "' id=" + id);
            }
        }
    }
}

