/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.impl.DirectoryIndex;
import com.intellij.openapi.roots.impl.DirectoryInfo;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public abstract class FileIndexBase
implements FileIndex {
    protected final FileTypeRegistry myFileTypeRegistry;
    protected final DirectoryIndex myDirectoryIndex;

    public FileIndexBase(@NotNull DirectoryIndex directoryIndex, @NotNull FileTypeRegistry fileTypeManager, @NotNull Project project2) {
        if (directoryIndex == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directoryIndex", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (fileTypeManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTypeManager", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/roots/impl/FileIndexBase", "<init>"));
        }
        this.myDirectoryIndex = directoryIndex;
        this.myFileTypeRegistry = fileTypeManager;
    }

    @NotNull
    protected DirectoryInfo getInfoForFileOrDirectory(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        DirectoryInfo directoryInfo = this.myDirectoryIndex.getInfoForFile(file2);
        if (directoryInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/impl/FileIndexBase", "getInfoForFileOrDirectory"));
        }
        return directoryInfo;
    }

    public boolean isContentSourceFile(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/roots/impl/FileIndexBase", "isContentSourceFile"));
        }
        return !file2.isDirectory() && !this.myFileTypeRegistry.isFileIgnored(file2) && this.isInSourceContent(file2);
    }
}

