/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.impl.ModuleManagerImpl;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.RootPolicy;
import com.intellij.openapi.roots.impl.ModuleRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ModifiableModelCommitter {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.module.impl.ModifiableModelCommitter");

    public static void multiCommit(@NotNull ModifiableRootModel[] rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ModifiableModelCommitter.multiCommit(Arrays.asList(rootModels), moduleModel);
    }

    public static void multiCommit(@NotNull Collection<ModifiableRootModel> rootModels, @NotNull ModifiableModuleModel moduleModel) {
        if (rootModels == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootModels", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        if (moduleModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleModel", "com/intellij/openapi/roots/impl/ModifiableModelCommitter", "multiCommit"));
        }
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        final List<RootModelImpl> modelsToCommit = ModifiableModelCommitter.getSortedChangedModels(rootModels, moduleModel);
        final ArrayList modelsToDispose = ContainerUtil.newArrayList(rootModels);
        modelsToDispose.removeAll(modelsToCommit);
        ModuleManagerImpl.commitModelWithRunnable(moduleModel, new Runnable(){

            @Override
            public void run() {
                for (RootModelImpl model : modelsToCommit) {
                    ModuleRootManagerImpl.doCommit(model);
                }
                for (RootModelImpl model : modelsToDispose) {
                    model.dispose();
                }
            }
        });
    }

    private static List<RootModelImpl> getSortedChangedModels(Collection<ModifiableRootModel> rootModels, ModifiableModuleModel moduleModel) {
        ArrayList result = ContainerUtil.newArrayListWithCapacity((int)rootModels.size());
        for (ModifiableRootModel model : rootModels) {
            RootModelImpl rootModel = (RootModelImpl)model;
            if (!rootModel.isChanged()) continue;
            result.add(rootModel);
        }
        DFSTBuilder<RootModelImpl> builder = ModifiableModelCommitter.createDFSTBuilder(result, moduleModel);
        Collections.sort(result, builder.comparator());
        return result;
    }

    private static DFSTBuilder<RootModelImpl> createDFSTBuilder(List<RootModelImpl> rootModels, final ModifiableModuleModel moduleModel) {
        Module[] modules;
        final HashMap nameToModel = ContainerUtil.newHashMap();
        for (RootModelImpl rootModelImpl : rootModels) {
            String name = rootModelImpl.getModule().getName();
            LOG.assertTrue(!nameToModel.containsKey(name), (Object)name);
            nameToModel.put(name, rootModelImpl);
        }
        for (Module module2 : modules = moduleModel.getModules()) {
            String name = module2.getName();
            if (nameToModel.containsKey(name)) continue;
            RootModelImpl rootModel = ((ModuleRootManagerImpl)ModuleRootManager.getInstance((Module)module2)).getRootModel();
            nameToModel.put(name, rootModel);
        }
        final Collection collection = nameToModel.values();
        GraphGenerator.SemiGraph<RootModelImpl> graph = new GraphGenerator.SemiGraph<RootModelImpl>(){

            public Collection<RootModelImpl> getNodes() {
                return collection;
            }

            public Iterator<RootModelImpl> getIn(RootModelImpl rootModel) {
                OrderEnumerator entries = rootModel.orderEntries().withoutSdk().withoutLibraries().withoutModuleSourceEntries();
                List namesList = (List)entries.process((RootPolicy)new RootPolicy<List<String>>(){

                    public List<String> visitModuleOrderEntry(ModuleOrderEntry moduleOrderEntry, List<String> strings) {
                        Module module2 = moduleOrderEntry.getModule();
                        if (module2 != null && !module2.isDisposed()) {
                            strings.add(module2.getName());
                        } else {
                            Module moduleToBeRenamed = moduleModel.getModuleToBeRenamed(moduleOrderEntry.getModuleName());
                            if (moduleToBeRenamed != null && !moduleToBeRenamed.isDisposed()) {
                                strings.add(moduleToBeRenamed.getName());
                            }
                        }
                        return strings;
                    }
                }, new ArrayList());
                String[] names = ArrayUtil.toStringArray((Collection)namesList);
                ArrayList<RootModelImpl> result = new ArrayList<RootModelImpl>();
                for (String name : names) {
                    RootModelImpl depRootModel = (RootModelImpl)nameToModel.get(name);
                    if (depRootModel == null) continue;
                    result.add(depRootModel);
                }
                return result.iterator();
            }
        };
        return new DFSTBuilder((Graph)new GraphGenerator((GraphGenerator.SemiGraph)new CachingSemiGraph((GraphGenerator.SemiGraph)graph)));
    }
}

