/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ContentRootPanel;
import java.awt.Color;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public abstract class ModuleSourceRootEditHandler<P extends JpsElement> {
    public static final ExtensionPointName<ModuleSourceRootEditHandler> EP_NAME = ExtensionPointName.create((String)"com.intellij.projectStructure.sourceRootEditHandler");
    private final JpsModuleSourceRootType<P> myRootType;

    protected ModuleSourceRootEditHandler(JpsModuleSourceRootType<P> rootType) {
        this.myRootType = rootType;
    }

    @Nullable
    public static <P extends JpsElement> ModuleSourceRootEditHandler<P> getEditHandler(@NotNull JpsModuleSourceRootType<P> type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getEditHandler"));
        }
        for (ModuleSourceRootEditHandler editor : (ModuleSourceRootEditHandler[])EP_NAME.getExtensions()) {
            if (!editor.getRootType().equals(type)) continue;
            return editor;
        }
        return null;
    }

    public final JpsModuleSourceRootType<P> getRootType() {
        return this.myRootType;
    }

    @NotNull
    public abstract String getRootTypeName();

    @NotNull
    public String getFullRootTypeName() {
        String string = ProjectBundle.message((String)"module.paths.root.node", (Object[])new Object[]{this.getRootTypeName()});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getFullRootTypeName"));
        }
        return string;
    }

    @NotNull
    public abstract Icon getRootIcon();

    @NotNull
    public Icon getRootIcon(@NotNull P properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getRootIcon"));
        }
        Icon icon = this.getRootIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getRootIcon"));
        }
        return icon;
    }

    @Nullable
    public abstract Icon getFolderUnderRootIcon();

    @Nullable
    public abstract CustomShortcutSet getMarkRootShortcutSet();

    @NotNull
    public abstract String getRootsGroupTitle();

    @NotNull
    public abstract Color getRootsGroupColor();

    @NotNull
    public String getMarkRootButtonText() {
        String string = this.getRootTypeName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getMarkRootButtonText"));
        }
        return string;
    }

    @NotNull
    public abstract String getUnmarkRootButtonText();

    @Nullable
    public String getPropertiesString(@NotNull P properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "getPropertiesString"));
        }
        return null;
    }

    @Nullable
    public JComponent createPropertiesEditor(@NotNull SourceFolder folder, @NotNull JComponent parentComponent, @NotNull ContentRootPanel.ActionCallback callback) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "createPropertiesEditor"));
        }
        if (parentComponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentComponent", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "createPropertiesEditor"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "callback", "com/intellij/openapi/roots/ui/configuration/ModuleSourceRootEditHandler", "createPropertiesEditor"));
        }
        return null;
    }
}

