/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.MouseGestureManager;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.popup.util.PopupUtil;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.WindowStateService;
import com.intellij.openapi.wm.FocusWatcher;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.IdeRootPaneNorthExtension;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.openapi.wm.ex.LayoutFocusTraversalPolicyExt;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.openapi.wm.impl.IdeFrameImpl;
import com.intellij.openapi.wm.impl.IdeGlassPaneImpl;
import com.intellij.openapi.wm.impl.IdeMenuBar;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.FocusTrackback;
import com.intellij.ui.FrameState;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FrameWrapper
implements Disposable,
DataProvider {
    private String myDimensionKey = null;
    private JComponent myComponent = null;
    private JComponent myPreferedFocus = null;
    private String myTitle = "";
    private Image myImage = ImageLoader.loadFromResource((String)ApplicationInfoImpl.getShadowInstance().getIconUrl());
    private boolean myCloseOnEsc = false;
    private Window myFrame;
    private final Map<String, Object> myDatas = new HashMap();
    private Project myProject;
    private final ProjectManagerListener myProjectListener = new MyProjectManagerListener();
    private FocusTrackback myFocusTrackback;
    private FocusWatcher myFocusWatcher;
    private ActionCallback myFocusedCallback;
    private boolean myDisposed;
    protected StatusBar myStatusBar;
    private boolean myShown;
    private boolean myIsDialog;
    private boolean myImageWasChanged;

    public FrameWrapper(Project project2) {
        this(project2, null);
    }

    public FrameWrapper(Project project2, @Nullable @NonNls String dimensionServiceKey) {
        this(project2, dimensionServiceKey, false);
    }

    public FrameWrapper(Project project2, @Nullable @NonNls String dimensionServiceKey, boolean isDialog) {
        this.myDimensionKey = dimensionServiceKey;
        this.myIsDialog = isDialog;
        if (project2 != null) {
            this.setProject(project2);
        }
    }

    public void setDimensionKey(String dimensionKey) {
        this.myDimensionKey = dimensionKey;
    }

    public void setData(String dataId, Object data) {
        this.myDatas.put(dataId, data);
    }

    public void setProject(final @NotNull Project project2) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/ui/FrameWrapper", "setProject"));
        }
        this.myProject = project2;
        this.setData(CommonDataKeys.PROJECT.getName(), project2);
        ProjectManager.getInstance().addProjectManagerListener(project2, this.myProjectListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                ProjectManager.getInstance().removeProjectManagerListener(project2, FrameWrapper.this.myProjectListener);
            }
        });
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean restoreBounds) {
        this.myFocusedCallback = new ActionCallback();
        if (this.myProject != null) {
            IdeFocusManager.getInstance((Project)this.myProject).typeAheadUntil(this.myFocusedCallback);
        }
        final Window frame = this.getFrame();
        if (this.myStatusBar != null) {
            this.myStatusBar.install((IdeFrame)frame);
        }
        this.myFocusTrackback = new FocusTrackback((Object)this, IdeFocusManager.findInstance().getFocusOwner(), true);
        if (frame instanceof JFrame) {
            ((JFrame)frame).setDefaultCloseOperation(2);
        } else {
            ((JDialog)frame).setDefaultCloseOperation(2);
        }
        final WindowAdapter focusListener = new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                IdeFocusManager fm = IdeFocusManager.getInstance((Project)FrameWrapper.this.myProject);
                JComponent toFocus = FrameWrapper.this.getPreferredFocusedComponent();
                if (toFocus == null) {
                    toFocus = fm.getFocusTargetFor(FrameWrapper.this.myComponent);
                }
                if (toFocus != null) {
                    fm.requestFocus((Component)toFocus, true).notify(FrameWrapper.this.myFocusedCallback);
                } else {
                    FrameWrapper.this.myFocusedCallback.setRejected();
                }
            }
        };
        frame.addWindowListener(focusListener);
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                frame.removeWindowListener(focusListener);
            }
        });
        if (this.myCloseOnEsc) {
            this.addCloseOnEsc((RootPaneContainer)((Object)frame));
        }
        ((RootPaneContainer)((Object)frame)).getContentPane().add((Component)this.myComponent, "Center");
        if (frame instanceof JFrame) {
            ((JFrame)frame).setTitle(this.myTitle);
        } else {
            ((JDialog)frame).setTitle(this.myTitle);
        }
        if (this.myImageWasChanged) {
            frame.setIconImage(this.myImage);
        } else {
            AppUIUtil.updateWindowIcon(this.myFrame);
        }
        if (restoreBounds) {
            this.loadFrameState();
        }
        this.myFocusWatcher = new FocusWatcher(){

            protected void focusLostImpl(FocusEvent e) {
                FrameWrapper.this.myFocusTrackback.consume();
            }
        };
        this.myFocusWatcher.install((Component)this.myComponent);
        this.myShown = true;
        frame.setVisible(true);
        if (UIUtil.isUnderAlloyLookAndFeel() && frame instanceof JFrame) {
            ((JFrame)frame).setMaximizedBounds(null);
        }
    }

    public void close() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        Window frame = this.getFrame();
        JRootPane rootPane = ((RootPaneContainer)((Object)frame)).getRootPane();
        if (rootPane != null) {
            DialogWrapper.unregisterKeyboardActions((JRootPane)rootPane);
        }
        frame.setVisible(false);
        if (frame instanceof JFrame) {
            FocusTrackback.release((JFrame)frame);
        }
        if (this.myStatusBar != null) {
            Disposer.dispose((Disposable)this.myStatusBar);
            this.myStatusBar = null;
        }
        frame.dispose();
        this.myDisposed = true;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    private void addCloseOnEsc(RootPaneContainer frame) {
        JRootPane rootPane = frame.getRootPane();
        ActionListener closeAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!PopupUtil.handleEscKeyEvent()) {
                    FrameWrapper.this.myFrame.setVisible(false);
                    FrameWrapper.this.close();
                }
            }
        };
        rootPane.registerKeyboardAction(closeAction, KeyStroke.getKeyStroke(27, 0), 2);
        ActionUtil.registerForEveryKeyboardShortcut((JComponent)rootPane, (ActionListener)closeAction, (ShortcutSet)CommonShortcuts.getCloseActiveWindow());
    }

    public Window getFrame() {
        assert (!this.myDisposed) : "Already disposed!";
        if (this.myFrame == null) {
            IdeFrame parent = WindowManager.getInstance().getIdeFrame(this.myProject);
            this.myFrame = this.myIsDialog ? this.createJDialog(parent) : this.createJFrame(parent);
        }
        return this.myFrame;
    }

    protected JFrame createJFrame(IdeFrame parent) {
        return new MyJFrame(parent){

            @Override
            public IdeRootPaneNorthExtension getNorthExtension(String key) {
                return FrameWrapper.this.getNorthExtension(key);
            }
        };
    }

    protected JDialog createJDialog(IdeFrame parent) {
        return new MyJDialog(parent);
    }

    protected IdeRootPaneNorthExtension getNorthExtension(String key) {
        return null;
    }

    public Object getData(@NonNls String dataId) {
        if (CommonDataKeys.PROJECT.is(dataId)) {
            return this.myProject;
        }
        return null;
    }

    public void setComponent(JComponent component) {
        this.myComponent = component;
    }

    public void setPreferredFocusedComponent(JComponent preferedFocus) {
        this.myPreferedFocus = preferedFocus;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPreferedFocus;
    }

    public void closeOnEsc() {
        this.myCloseOnEsc = true;
    }

    public void setImage(Image image) {
        this.myImageWasChanged = true;
        this.myImage = image;
    }

    protected void loadFrameState() {
        IdeFrame ideFrame;
        Window frame = this.getFrame();
        if (this.myDimensionKey != null && !WindowStateService.getInstance().loadStateFor((Object)this.myProject, this.myDimensionKey, (Component)frame) && (ideFrame = WindowManagerEx.getInstanceEx().getIdeFrame(this.myProject)) != null) {
            frame.setBounds(ideFrame.suggestChildFrameBounds());
        }
        ((RootPaneContainer)((Object)frame)).getRootPane().revalidate();
    }

    public void setTitle(String title) {
        this.myTitle = title;
    }

    public void addDisposable(@NotNull Disposable disposable) {
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/openapi/ui/FrameWrapper", "addDisposable"));
        }
        Disposer.register((Disposable)this, (Disposable)disposable);
    }

    protected void setStatusBar(StatusBar statusBar) {
        if (this.myStatusBar != null) {
            Disposer.dispose((Disposable)this.myStatusBar);
        }
        this.myStatusBar = statusBar;
    }

    public void setLocation(Point location) {
        this.getFrame().setLocation(location);
    }

    public void setSize(Dimension size) {
        this.getFrame().setSize(size);
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        private MyProjectManagerListener() {
        }

        public void projectClosing(Project project2) {
            if (project2 == FrameWrapper.this.myProject) {
                FrameWrapper.this.close();
            }
        }
    }

    private class MyJDialog
    extends JDialog
    implements DataProvider,
    IdeFrame.Child {
        private boolean myDisposing;
        private final IdeFrame myParent;

        private MyJDialog(IdeFrame parent) throws HeadlessException {
            super((JFrame)parent);
            this.myParent = parent;
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane()));
            this.getRootPane().putClientProperty("Window.style", "small");
            this.setBackground(UIUtil.getPanelBackground());
            MouseGestureManager.getInstance().add((IdeFrame)this);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt());
            this.setDefaultCloseOperation(2);
        }

        public JComponent getComponent() {
            return this.getRootPane();
        }

        public StatusBar getStatusBar() {
            return null;
        }

        @Nullable
        public BalloonLayout getBalloonLayout() {
            return null;
        }

        public Rectangle suggestChildFrameBounds() {
            return this.myParent.suggestChildFrameBounds();
        }

        public Project getProject() {
            return this.myParent.getProject();
        }

        public void setFrameTitle(String title) {
            this.setTitle(title);
        }

        public void setFileTitle(String fileTitle, File ioFile) {
            this.setTitle(fileTitle);
        }

        public IdeRootPaneNorthExtension getNorthExtension(String key) {
            return null;
        }

        public IdeFrame getParentFrame() {
            return this.myParent;
        }

        @Override
        public void dispose() {
            if (this.myDisposing) {
                return;
            }
            this.myDisposing = true;
            MouseGestureManager.getInstance().remove((IdeFrame)this);
            if (FrameWrapper.this.myShown && FrameWrapper.this.myDimensionKey != null) {
                WindowStateService.getInstance().saveStateFor((Object)FrameWrapper.this.myProject, FrameWrapper.this.myDimensionKey, (Component)this);
            }
            Disposer.dispose((Disposable)FrameWrapper.this);
            FrameWrapper.this.myDatas.clear();
            FrameWrapper.this.myProject = null;
            FrameWrapper.this.myPreferedFocus = null;
            if (FrameWrapper.this.myFocusTrackback != null) {
                FrameWrapper.this.myFocusTrackback.restoreFocus();
            }
            if (FrameWrapper.this.myComponent != null && FrameWrapper.this.myFocusWatcher != null) {
                FrameWrapper.this.myFocusWatcher.deinstall((Component)FrameWrapper.this.myComponent);
            }
            FrameWrapper.this.myFocusWatcher = null;
            FrameWrapper.this.myFocusedCallback = null;
            super.dispose();
        }

        public Object getData(String dataId) {
            if (IdeFrame.KEY.getName().equals(dataId)) {
                return this;
            }
            Object data = FrameWrapper.this.getData(dataId);
            return data != null ? data : FrameWrapper.this.myDatas.get(dataId);
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }
    }

    private class MyJFrame
    extends JFrame
    implements DataProvider,
    IdeFrame.Child {
        private boolean myDisposing;
        private final IdeFrame myParent;
        private String myFrameTitle;
        private String myFileTitle;
        private File myFile;

        private MyJFrame(IdeFrame parent) throws HeadlessException {
            FrameState.setFrameStateListener(this);
            this.myParent = parent;
            this.setGlassPane(new IdeGlassPaneImpl(this.getRootPane()));
            boolean setMenuOnFrame = SystemInfo.isMac;
            if (SystemInfo.isLinux && "Unity".equals(System.getenv("XDG_CURRENT_DESKTOP"))) {
                try {
                    Class.forName("com.jarego.jayatana.Agent");
                    setMenuOnFrame = true;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (setMenuOnFrame) {
                this.setJMenuBar(new IdeMenuBar(ActionManagerEx.getInstanceEx(), DataManager.getInstance()));
            }
            MouseGestureManager.getInstance().add((IdeFrame)this);
            this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicyExt());
            this.setDefaultCloseOperation(2);
        }

        public JComponent getComponent() {
            return this.getRootPane();
        }

        public StatusBar getStatusBar() {
            return FrameWrapper.this.myStatusBar != null ? FrameWrapper.this.myStatusBar : this.myParent.getStatusBar();
        }

        public Rectangle suggestChildFrameBounds() {
            return this.myParent.suggestChildFrameBounds();
        }

        public Project getProject() {
            return this.myParent.getProject();
        }

        public void setFrameTitle(String title) {
            this.myFrameTitle = title;
            this.updateTitle();
        }

        public void setFileTitle(String fileTitle, File ioFile) {
            this.myFileTitle = fileTitle;
            this.myFile = ioFile;
            this.updateTitle();
        }

        public IdeRootPaneNorthExtension getNorthExtension(String key) {
            return null;
        }

        public BalloonLayout getBalloonLayout() {
            return null;
        }

        private void updateTitle() {
            IdeFrameImpl.updateTitle(this, this.myFrameTitle, this.myFileTitle, this.myFile);
        }

        public IdeFrame getParentFrame() {
            return this.myParent;
        }

        @Override
        public void dispose() {
            if (this.myDisposing) {
                return;
            }
            this.myDisposing = true;
            MouseGestureManager.getInstance().remove((IdeFrame)this);
            if (FrameWrapper.this.myShown && FrameWrapper.this.myDimensionKey != null) {
                WindowStateService.getInstance().saveStateFor((Object)FrameWrapper.this.myProject, FrameWrapper.this.myDimensionKey, (Component)this);
            }
            Disposer.dispose((Disposable)FrameWrapper.this);
            FrameWrapper.this.myDatas.clear();
            FrameWrapper.this.myProject = null;
            FrameWrapper.this.myPreferedFocus = null;
            if (FrameWrapper.this.myFocusTrackback != null) {
                FrameWrapper.this.myFocusTrackback.restoreFocus();
            }
            if (FrameWrapper.this.myComponent != null && FrameWrapper.this.myFocusWatcher != null) {
                FrameWrapper.this.myFocusWatcher.deinstall((Component)FrameWrapper.this.myComponent);
            }
            FrameWrapper.this.myFocusWatcher = null;
            FrameWrapper.this.myFocusedCallback = null;
            super.dispose();
        }

        public Object getData(String dataId) {
            if (IdeFrame.KEY.getName().equals(dataId)) {
                return this;
            }
            Object data = FrameWrapper.this.getData(dataId);
            return data != null ? data : FrameWrapper.this.myDatas.get(dataId);
        }

        @Override
        public void paint(Graphics g) {
            UISettings.setupAntialiasing((Graphics)g);
            super.paint(g);
        }
    }
}

