/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.ChangeListsIndexes;
import com.intellij.util.BeforeAfter;
import com.intellij.util.PlusMinusModify;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class ChangesDelta {
    private final PlusMinusModify<BaseRevision> myDeltaListener;
    private boolean myInitialized;

    public ChangesDelta(PlusMinusModify<BaseRevision> deltaListener) {
        this.myDeltaListener = deltaListener;
    }

    public boolean step(ChangeListsIndexes was, ChangeListsIndexes became) {
        List<BaseRevision> wasAffected = was.getAffectedFilesUnderVcs();
        if (!this.myInitialized) {
            this.sendPlus(wasAffected);
            this.myInitialized = true;
            return true;
        }
        HashSet<BaseRevision> toRemove = new HashSet<BaseRevision>();
        HashSet<BaseRevision> toAdd = new HashSet<BaseRevision>();
        HashSet<BeforeAfter<BaseRevision>> toModify = new HashSet<BeforeAfter<BaseRevision>>();
        was.getDelta(became, toRemove, toAdd, toModify);
        for (BaseRevision baseRevision : toRemove) {
            this.myDeltaListener.minus((Object)baseRevision);
        }
        this.sendPlus(toAdd);
        for (BeforeAfter beforeAfter : toModify) {
            this.myDeltaListener.modify(beforeAfter.getBefore(), beforeAfter.getAfter());
        }
        return !toRemove.isEmpty() || !toAdd.isEmpty();
    }

    private void sendPlus(Collection<BaseRevision> toAdd) {
        if (toAdd != null) {
            for (BaseRevision pair : toAdd) {
                this.myDeltaListener.plus((Object)pair);
            }
        }
    }
}

