/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDirectoryMapping;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerImpl;
import com.intellij.openapi.vcs.changes.DirtBuilder;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.VcsGuess;
import com.intellij.openapi.vcs.changes.VcsInvalidated;
import com.intellij.openapi.vcs.impl.DefaultVcsRootPolicy;
import com.intellij.openapi.vcs.impl.ProjectLevelVcsManagerImpl;
import com.intellij.openapi.vcs.impl.VcsInitObject;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsDirtyScopeManagerImpl
extends VcsDirtyScopeManager
implements ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl");
    private final Project myProject;
    private final ChangeListManager myChangeListManager;
    private final ProjectLevelVcsManagerImpl myVcsManager;
    private final VcsGuess myGuess;
    private final DirtBuilder myDirtBuilder;
    @Nullable
    private DirtBuilder myDirtInProgress;
    private boolean myReady;
    private final Object LOCK = new Object();

    public VcsDirtyScopeManagerImpl(Project project2, ChangeListManager changeListManager, ProjectLevelVcsManager vcsManager) {
        this.myProject = project2;
        this.myChangeListManager = changeListManager;
        this.myVcsManager = (ProjectLevelVcsManagerImpl)vcsManager;
        this.myGuess = new VcsGuess(this.myProject);
        this.myDirtBuilder = new DirtBuilder(this.myGuess);
        ((ChangeListManagerImpl)this.myChangeListManager).setDirtyScopeManager(this);
    }

    public void projectOpened() {
        this.myVcsManager.addInitializationRequest(VcsInitObject.DIRTY_SCOPE_MANAGER, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = VcsDirtyScopeManagerImpl.this.LOCK;
                synchronized (object) {
                    if (!VcsDirtyScopeManagerImpl.this.myProject.isDisposed()) {
                        VcsDirtyScopeManagerImpl.this.myReady = true;
                    }
                }
                VcsDirtyScopeManagerImpl.this.markEverythingDirty();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markEverythingDirty() {
        if (!this.myProject.isOpen() || this.myProject.isDisposed() || this.myVcsManager.getAllActiveVcss().length == 0) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("everything dirty: " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.myReady) {
                this.myDirtBuilder.everythingDirty();
            }
        }
        this.myChangeListManager.scheduleUpdate();
    }

    public void projectClosed() {
    }

    @NotNull
    @NonNls
    public String getComponentName() {
        if ("VcsDirtyScopeManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "getComponentName"));
        }
        return "VcsDirtyScopeManager";
    }

    public void initComponent() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myReady = false;
            this.myDirtBuilder.reset();
            this.myDirtInProgress = null;
        }
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> groupByVcs(@Nullable Collection<FilePath> from) {
        if (from == null) {
            MultiMap multiMap = MultiMap.empty();
            if (multiMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "groupByVcs"));
            }
            return multiMap;
        }
        MultiMap map = MultiMap.createSet();
        for (FilePath path : from) {
            AbstractVcs vcs = this.myGuess.getVcsForDirty(path);
            if (vcs == null) continue;
            map.putValue((Object)vcs, (Object)path);
        }
        MultiMap multiMap = map;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "groupByVcs"));
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filePathsDirty(@Nullable Collection<FilePath> filesDirty, @Nullable Collection<FilePath> dirsRecursivelyDirty) {
        try {
            boolean hasSomethingDirty;
            MultiMap<AbstractVcs, FilePath> filesConverted = this.groupByVcs(filesDirty);
            MultiMap<AbstractVcs, FilePath> dirsConverted = this.groupByVcs(dirsRecursivelyDirty);
            if (filesConverted.isEmpty() && dirsConverted.isEmpty()) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("dirty files: " + VcsDirtyScopeManagerImpl.toString(filesConverted) + "; dirty dirs: " + VcsDirtyScopeManagerImpl.toString(dirsConverted) + "; " + VcsDirtyScopeManagerImpl.findFirstInterestingCallerClass());
            }
            Object object = this.LOCK;
            synchronized (object) {
                if (!this.myReady) {
                    return;
                }
                VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, filesConverted, false);
                VcsDirtyScopeManagerImpl.markDirty(this.myDirtBuilder, dirsConverted, true);
                hasSomethingDirty = !this.myDirtBuilder.isEmpty();
            }
            if (hasSomethingDirty) {
                this.myChangeListManager.scheduleUpdate();
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            // empty catch block
        }
    }

    private static void markDirty(@NotNull DirtBuilder dirtBuilder, @NotNull MultiMap<AbstractVcs, FilePath> filesOrDirs, boolean recursively) {
        if (dirtBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirtBuilder", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "markDirty"));
        }
        if (filesOrDirs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesOrDirs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "markDirty"));
        }
        for (AbstractVcs vcs : filesOrDirs.keySet()) {
            for (FilePath path : filesOrDirs.get((Object)vcs)) {
                if (recursively) {
                    dirtBuilder.addDirtyDirRecursively(vcs, path);
                    continue;
                }
                dirtBuilder.addDirtyFile(vcs, path);
            }
        }
    }

    public void filesDirty(@Nullable Collection<VirtualFile> filesDirty, @Nullable Collection<VirtualFile> dirsRecursivelyDirty) {
        this.filePathsDirty(VcsDirtyScopeManagerImpl.toFilePaths(filesDirty), VcsDirtyScopeManagerImpl.toFilePaths(dirsRecursivelyDirty));
    }

    @NotNull
    private static Collection<FilePath> toFilePaths(@Nullable Collection<VirtualFile> files) {
        if (files == null) {
            List<FilePath> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "toFilePaths"));
            }
            return list;
        }
        List list = ContainerUtil.map(files, (Function)new Function<VirtualFile, FilePath>(){

            public FilePath fun(VirtualFile virtualFile) {
                return VcsUtil.getFilePath((VirtualFile)virtualFile);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "toFilePaths"));
        }
        return list;
    }

    public void fileDirty(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "fileDirty"));
        }
        this.fileDirty(VcsUtil.getFilePath((VirtualFile)file2));
    }

    public void fileDirty(@NotNull FilePath file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "fileDirty"));
        }
        this.filePathsDirty(Collections.singleton(file2), null);
    }

    public void dirDirtyRecursively(VirtualFile dir, boolean scheduleUpdate) {
        this.dirDirtyRecursively(dir);
    }

    public void dirDirtyRecursively(VirtualFile dir) {
        this.dirDirtyRecursively(VcsUtil.getFilePath((VirtualFile)dir));
    }

    public void dirDirtyRecursively(FilePath path) {
        this.filePathsDirty(null, Collections.singleton(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public VcsInvalidated retrieveScopes() {
        DirtBuilder dirtBuilder;
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                return null;
            }
            this.myDirtInProgress = dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            this.myDirtBuilder.reset();
        }
        return this.calculateInvalidated(dirtBuilder);
    }

    @NotNull
    private VcsInvalidated calculateInvalidated(@NotNull DirtBuilder dirt) {
        if (dirt == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dirt", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "calculateInvalidated"));
        }
        MultiMap<AbstractVcs, FilePath> files = dirt.getFilesForVcs();
        MultiMap<AbstractVcs, FilePath> dirs = dirt.getDirsForVcs();
        if (dirt.isEverythingDirty()) {
            dirs.putAllValues(this.getEverythingDirtyRoots());
        }
        Set keys = ContainerUtil.union((Set)files.keySet(), (Set)dirs.keySet());
        HashMap scopes = ContainerUtil.newHashMap();
        for (AbstractVcs key : keys) {
            VcsDirtyScopeImpl scope = new VcsDirtyScopeImpl(key, this.myProject);
            scopes.put(key, scope);
            scope.addDirtyData(dirs.get((Object)key), files.get((Object)key));
        }
        VcsInvalidated vcsInvalidated = new VcsInvalidated(new ArrayList(scopes.values()), dirt.isEverythingDirty());
        if (vcsInvalidated == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "calculateInvalidated"));
        }
        return vcsInvalidated;
    }

    @NotNull
    private MultiMap<AbstractVcs, FilePath> getEverythingDirtyRoots() {
        MultiMap dirtyRoots = MultiMap.createSet();
        dirtyRoots.putAllValues(this.groupByVcs(VcsDirtyScopeManagerImpl.toFilePaths(DefaultVcsRootPolicy.getInstance(this.myProject).getDirtyRoots())));
        List<VcsDirectoryMapping> mappings = this.myVcsManager.getDirectoryMappings();
        for (VcsDirectoryMapping mapping : mappings) {
            AbstractVcs vcs;
            if (mapping.isDefaultMapping() || mapping.getVcs() == null || (vcs = this.myVcsManager.findVcsByName(mapping.getVcs())) == null) continue;
            dirtyRoots.putValue((Object)vcs, (Object)VcsUtil.getFilePath((String)mapping.getDirectory(), (boolean)true));
        }
        MultiMap multiMap = dirtyRoots;
        if (multiMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "getEverythingDirtyRoots"));
        }
        return multiMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changesProcessed() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myDirtInProgress = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public Collection<FilePath> whatFilesDirty(@NotNull Collection<FilePath> files) {
        DirtBuilder dirtBuilderInProgress;
        DirtBuilder dirtBuilder;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "whatFilesDirty"));
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (!this.myReady) {
                List<FilePath> list = Collections.emptyList();
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var4_2
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "whatFilesDirty"));
                }
                return list;
            }
            dirtBuilder = new DirtBuilder(this.myDirtBuilder);
            dirtBuilderInProgress = this.myDirtInProgress != null ? new DirtBuilder(this.myDirtInProgress) : new DirtBuilder(this.myGuess);
        }
        VcsInvalidated invalidated = this.calculateInvalidated(dirtBuilder);
        VcsInvalidated inProgress = this.calculateInvalidated(dirtBuilderInProgress);
        ArrayList result = ContainerUtil.newArrayList();
        for (FilePath fp : files) {
            if (!invalidated.isFileDirty(fp) && !inProgress.isFileDirty(fp)) continue;
            result.add(fp);
        }
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "whatFilesDirty"));
        }
        return arrayList;
    }

    @NotNull
    private static String toString(final @NotNull MultiMap<AbstractVcs, FilePath> filesByVcs) {
        if (filesByVcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filesByVcs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "toString"));
        }
        String string = StringUtil.join((Collection)filesByVcs.keySet(), (Function)new Function<AbstractVcs, String>(){

            public String fun(@NotNull AbstractVcs vcs) {
                if (vcs == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$3", "fun"));
                }
                return vcs.getName() + ": " + StringUtil.join((Collection)filesByVcs.get((Object)vcs), (Function)new Function<FilePath, String>(){

                    public String fun(@NotNull FilePath path) {
                        if (path == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl$3$1", "fun"));
                        }
                        return path.getPath();
                    }
                }, (String)"\n");
            }
        }, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/VcsDirtyScopeManagerImpl", "toString"));
        }
        return string;
    }

    @Nullable
    private static Class findFirstInterestingCallerClass() {
        for (int i = 1; i <= 5; ++i) {
            Class clazz = ReflectionUtil.findCallerClass((int)i);
            if (clazz != null && clazz.getName().contains(VcsDirtyScopeManagerImpl.class.getName())) continue;
            return clazz;
        }
        return null;
    }
}

