/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.changes.actions.RollbackDeletionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesListView;
import com.intellij.openapi.vcs.changes.ui.RollbackChangesDialog;
import com.intellij.openapi.vcs.changes.ui.RollbackProgressModifier;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.rollback.RollbackProgressListener;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.RollbackUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RollbackAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        boolean visible = project2 != null && ProjectLevelVcsManager.getInstance((Project)project2).hasActiveVcss();
        e.getPresentation().setEnabledAndVisible(visible);
        if (!visible) {
            return;
        }
        Change[] leadSelection = (Change[])e.getData(VcsDataKeys.CHANGE_LEAD_SELECTION);
        boolean isEnabled = leadSelection != null && leadSelection.length > 0 || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_LOCALLY_DELETED)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_MODIFIED_WITHOUT_EDITING)) || Boolean.TRUE.equals(e.getData(VcsDataKeys.HAVE_SELECTED_CHANGES)) || RollbackAction.hasReversibleFiles(e, project2) || RollbackAction.currentChangelistNotEmpty(project2);
        e.getPresentation().setEnabled(isEnabled);
        String operationName = RollbackUtil.getRollbackOperationName(project2);
        e.getPresentation().setText(operationName + "...");
        if (isEnabled) {
            e.getPresentation().setDescription(UIUtil.removeMnemonic((String)operationName) + " selected changes");
        }
    }

    private static boolean hasReversibleFiles(AnActionEvent e, Project project2) {
        VirtualFile[] files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (files != null) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)project2);
            HashSet modifiedWithoutEditing = ContainerUtil.newHashSet((Iterable)clManager.getModifiedWithoutEditing());
            for (VirtualFile file2 : files) {
                if (clManager.haveChangesUnder(file2) == ThreeState.NO && !clManager.isFileAffected(file2) && !modifiedWithoutEditing.contains(file2)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean currentChangelistNotEmpty(Project project2) {
        ChangeListManager clManager = ChangeListManager.getInstance((Project)project2);
        LocalChangeList list = clManager.getDefaultChangeList();
        return list != null && !list.getChanges().isEmpty();
    }

    public void actionPerformed(AnActionEvent e) {
        String title;
        Project project2 = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project2 == null) {
            return;
        }
        String string = title = "ChangesViewToolbar".equals(e.getPlace()) ? null : "Can not " + RollbackUtil.getRollbackOperationName(project2) + " now";
        if (ChangeListManager.getInstance((Project)project2).isFreezedWithNotification(title)) {
            return;
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        List missingFiles = (List)e.getData(ChangesListView.MISSING_FILES_DATA_KEY);
        boolean hasChanges = false;
        if (missingFiles != null && !missingFiles.isEmpty()) {
            hasChanges = true;
            new RollbackDeletionAction().actionPerformed(e);
        }
        List changes = RollbackAction.getChanges(project2, e);
        final LinkedHashSet<VirtualFile> modifiedWithoutEditing = RollbackAction.getModifiedWithoutEditing(e, project2);
        if (modifiedWithoutEditing != null && !modifiedWithoutEditing.isEmpty()) {
            hasChanges = true;
            RollbackAction.rollbackModifiedWithoutEditing(project2, modifiedWithoutEditing);
        }
        if (modifiedWithoutEditing != null) {
            changes = ContainerUtil.filter(changes, (Condition)new Condition<Change>(){

                public boolean value(Change change) {
                    return !modifiedWithoutEditing.contains(change.getVirtualFile());
                }
            });
        }
        if (!changes.isEmpty()) {
            RollbackChangesDialog.rollbackChanges(project2, changes);
        } else if (!hasChanges) {
            LocalChangeList currentChangeList = ChangeListManager.getInstance((Project)project2).getDefaultChangeList();
            RollbackChangesDialog.rollbackChanges(project2, currentChangeList);
        }
    }

    @NotNull
    private static List<Change> getChanges(Project project2, AnActionEvent e) {
        VirtualFile[] files;
        Object[] changes = (Change[])e.getData(VcsDataKeys.CHANGES);
        if (changes == null && (files = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY)) != null) {
            ChangeListManager clManager = ChangeListManager.getInstance((Project)project2);
            ArrayList changesList = new ArrayList();
            for (VirtualFile vf : files) {
                changesList.addAll(clManager.getChangesIn(vf));
            }
            if (!changesList.isEmpty()) {
                changes = changesList.toArray(new Change[changesList.size()]);
            }
        }
        if (changes != null && changes.length > 0) {
            ArrayList arrayList = ContainerUtil.newArrayList((Object[])changes);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/RollbackAction", "getChanges"));
            }
            return arrayList;
        }
        List<Change> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vcs/changes/actions/RollbackAction", "getChanges"));
        }
        return list;
    }

    @Nullable
    private static LinkedHashSet<VirtualFile> getModifiedWithoutEditing(AnActionEvent e, Project project2) {
        List modifiedWithoutEditing = (List)e.getData(VcsDataKeys.MODIFIED_WITHOUT_EDITING_DATA_KEY);
        if (modifiedWithoutEditing != null && modifiedWithoutEditing.size() > 0) {
            return new LinkedHashSet<VirtualFile>(modifiedWithoutEditing);
        }
        VirtualFile[] virtualFiles = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (virtualFiles != null && virtualFiles.length > 0) {
            LinkedHashSet<VirtualFile> result = new LinkedHashSet<VirtualFile>(Arrays.asList(virtualFiles));
            result.retainAll(ChangeListManager.getInstance((Project)project2).getModifiedWithoutEditing());
            return result;
        }
        return null;
    }

    private static void rollbackModifiedWithoutEditing(final Project project2, final LinkedHashSet<VirtualFile> modifiedWithoutEditing) {
        final String operationName = StringUtil.decapitalize((String)UIUtil.removeMnemonic((String)RollbackUtil.getRollbackOperationName(project2)));
        String message = modifiedWithoutEditing.size() == 1 ? VcsBundle.message((String)"rollback.modified.without.editing.confirm.single", (Object[])new Object[]{operationName, ((VirtualFile)modifiedWithoutEditing.iterator().next()).getPresentableUrl()}) : VcsBundle.message((String)"rollback.modified.without.editing.confirm.multiple", (Object[])new Object[]{operationName, modifiedWithoutEditing.size()});
        int rc = Messages.showYesNoDialog((Project)project2, (String)message, (String)VcsBundle.message((String)"changes.action.rollback.title", (Object[])new Object[]{operationName}), (Icon)Messages.getQuestionIcon());
        if (rc != 0) {
            return;
        }
        final ArrayList exceptions = new ArrayList();
        final ProgressManager progressManager = ProgressManager.getInstance();
        Runnable action = new Runnable(){

            @Override
            public void run() {
                final ProgressIndicator indicator = progressManager.getProgressIndicator();
                try {
                    ChangesUtil.processVirtualFilesByVcs((Project)project2, (Collection)modifiedWithoutEditing, (ChangesUtil.PerVcsProcessor)new ChangesUtil.PerVcsProcessor<VirtualFile>(){

                        public void process(AbstractVcs vcs, List<VirtualFile> items) {
                            RollbackEnvironment rollbackEnvironment = vcs.getRollbackEnvironment();
                            if (rollbackEnvironment != null) {
                                if (indicator != null) {
                                    indicator.setText(vcs.getDisplayName() + ": performing " + UIUtil.removeMnemonic((String)rollbackEnvironment.getRollbackOperationName()).toLowerCase() + "...");
                                    indicator.setIndeterminate(false);
                                }
                                rollbackEnvironment.rollbackModifiedWithoutCheckout(items, exceptions, (RollbackProgressListener)new RollbackProgressModifier(items.size(), indicator));
                                if (indicator != null) {
                                    indicator.setText2("");
                                }
                            }
                        }
                    });
                }
                catch (ProcessCanceledException processCanceledException) {
                    // empty catch block
                }
                if (!exceptions.isEmpty()) {
                    AbstractVcsHelper.getInstance((Project)project2).showErrors(exceptions, VcsBundle.message((String)"rollback.modified.without.checkout.error.tab", (Object[])new Object[]{operationName}));
                }
                VfsUtil.markDirty((boolean)true, (boolean)false, (VirtualFile[])VfsUtilCore.toVirtualFileArray((Collection)modifiedWithoutEditing));
                VirtualFileManager.getInstance().asyncRefresh(new Runnable(){

                    @Override
                    public void run() {
                        for (VirtualFile virtualFile : modifiedWithoutEditing) {
                            VcsDirtyScopeManager.getInstance((Project)project2).fileDirty(virtualFile);
                        }
                    }
                });
            }
        };
        progressManager.runProcessWithProgressSynchronously(action, operationName, true, project2);
    }
}

