/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.CommitLegendPanel;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;

public class ChangeInfoCalculator
implements CommitLegendPanel.InfoCalculator {
    private List<Change> myDisplayedChanges = Collections.emptyList();
    private List<Change> myIncludedChanges = Collections.emptyList();
    private static final Processor<Change> MODIFIED_FILTER = new Processor<Change>(){

        public boolean process(Change item) {
            return item.getType() == Change.Type.MODIFICATION || item.getType() == Change.Type.MOVED;
        }
    };
    private static final Processor<Change> NEW_FILTER = new Processor<Change>(){

        public boolean process(Change item) {
            return item.getType() == Change.Type.NEW;
        }
    };
    private static final Processor<Change> DELETED_FILTER = new Processor<Change>(){

        public boolean process(Change item) {
            return item.getType() == Change.Type.DELETED;
        }
    };

    public void update(List<Change> displayedChanges, List<Change> includedChanges) {
        this.myDisplayedChanges = displayedChanges;
        this.myIncludedChanges = includedChanges;
    }

    @Override
    public int getNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, NEW_FILTER);
    }

    @Override
    public int getModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myDisplayedChanges, DELETED_FILTER);
    }

    @Override
    public int getIncludedNew() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, NEW_FILTER);
    }

    @Override
    public int getIncludedModified() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, MODIFIED_FILTER);
    }

    @Override
    public int getIncludedDeleted() {
        return ChangeInfoCalculator.countMatchingItems(this.myIncludedChanges, DELETED_FILTER);
    }

    private static <T> int countMatchingItems(List<T> items, Processor<T> filter) {
        int count = 0;
        for (T item : items) {
            if (!filter.process(item)) continue;
            ++count;
        }
        return count;
    }
}

