/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.ui;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ui.TreeModelBuilder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import javax.swing.JList;

public class VirtualFileListCellRenderer
extends ColoredListCellRenderer {
    private final FileStatusManager myFileStatusManager;
    private final boolean myIgnoreFileStatus;

    public VirtualFileListCellRenderer(Project project2) {
        this(project2, false);
    }

    public VirtualFileListCellRenderer(Project project2, boolean ignoreFileStatus) {
        this.myIgnoreFileStatus = ignoreFileStatus;
        this.myFileStatusManager = FileStatusManager.getInstance((Project)project2);
    }

    protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
        FilePath path = TreeModelBuilder.getPathForObject(value);
        this.renderIcon(path);
        FileStatus fileStatus = this.myIgnoreFileStatus ? FileStatus.NOT_CHANGED : this.getStatus(value, path);
        this.append(this.getName(path), new SimpleTextAttributes(0, fileStatus.getColor(), null));
        this.putParentPath(value, path, path);
        this.setBackground(selected ? (hasFocus ? UIUtil.getListSelectionBackground() : UIUtil.getListUnfocusedSelectionBackground()) : UIUtil.getListBackground());
    }

    protected String getName(FilePath path) {
        return path.getName();
    }

    protected FileStatus getStatus(Object value, FilePath path) {
        VirtualFile virtualFile;
        FileStatus fileStatus = value instanceof Change ? ((Change)value).getFileStatus() : ((virtualFile = path.getVirtualFile()) != null ? this.myFileStatusManager.getStatus(virtualFile) : FileStatus.NOT_CHANGED);
        return fileStatus;
    }

    protected void renderIcon(FilePath path) {
        if (path.isDirectory()) {
            this.setIcon(PlatformIcons.DIRECTORY_CLOSED_ICON);
        } else {
            this.setIcon(path.getFileType().getIcon());
        }
    }

    protected void putParentPath(Object value, FilePath path, FilePath self) {
        File parentFile = path.getIOFile().getParentFile();
        if (parentFile != null) {
            String parentPath = parentFile.getPath();
            this.append(" (", SimpleTextAttributes.GRAYED_ATTRIBUTES);
            this.putParentPathImpl(value, parentPath, self);
            this.append(")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
        }
    }

    protected void putParentPathImpl(Object value, String parentPath, FilePath self) {
        this.append(parentPath, SimpleTextAttributes.GRAYED_ATTRIBUTES);
    }
}

