/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vfs.impl;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.IdentityVirtualFilePointer;
import com.intellij.openapi.vfs.impl.VirtualFilePointerContainerImpl;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerContainer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerListener;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoreVirtualFilePointerManager
extends VirtualFilePointerManager {
    @NotNull
    public VirtualFilePointer create(@NotNull String url, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        VirtualFile vFile = VirtualFileManager.getInstance().findFileByUrl(url);
        IdentityVirtualFilePointer identityVirtualFilePointer = new IdentityVirtualFilePointer(vFile, url);
        if (identityVirtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    public VirtualFilePointer create(@NotNull VirtualFile file2, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        IdentityVirtualFilePointer identityVirtualFilePointer = new IdentityVirtualFilePointer(file2, file2.getUrl());
        if (identityVirtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "create"));
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    public VirtualFilePointer duplicate(@NotNull VirtualFilePointer pointer, @NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (pointer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pointer", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        IdentityVirtualFilePointer identityVirtualFilePointer = new IdentityVirtualFilePointer(pointer.getFile(), pointer.getUrl());
        if (identityVirtualFilePointer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "duplicate"));
        }
        return identityVirtualFilePointer;
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        VirtualFilePointerContainer virtualFilePointerContainer = this.createContainer(parent, null);
        if (virtualFilePointerContainer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        return virtualFilePointerContainer;
    }

    @NotNull
    public VirtualFilePointerContainer createContainer(@NotNull Disposable parent, @Nullable VirtualFilePointerListener listener2) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        VirtualFilePointerContainerImpl virtualFilePointerContainerImpl = new VirtualFilePointerContainerImpl(this, parent, listener2);
        if (virtualFilePointerContainerImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/vfs/impl/CoreVirtualFilePointerManager", "createContainer"));
        }
        return virtualFilePointerContainerImpl;
    }

    public void dispose() {
    }
}

