/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packaging.impl.compiler;

import com.intellij.compiler.impl.ModuleCompileScope;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactManager;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.impl.elements.ArtifactElementType;
import com.intellij.packaging.impl.elements.ArtifactPackagingElement;
import com.intellij.packaging.impl.elements.ModuleOutputPackagingElement;
import com.intellij.packaging.impl.elements.ProductionModuleOutputElementType;
import com.intellij.util.Processor;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ArtifactCompileScope {
    private static final Key<Boolean> FORCE_ARTIFACT_BUILD = Key.create((String)"force_artifact_build");
    private static final Key<Artifact[]> ARTIFACTS_KEY = Key.create((String)"artifacts");
    private static final Key<Set<Artifact>> CACHED_ARTIFACTS_KEY = Key.create((String)"cached_artifacts");

    private ArtifactCompileScope() {
    }

    public static ModuleCompileScope createScopeForModulesInArtifacts(@NotNull Project project2, @NotNull Collection<? extends Artifact> artifacts) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createScopeForModulesInArtifacts"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createScopeForModulesInArtifacts"));
        }
        Set<Module> modules = ArtifactUtil.getModulesIncludedInArtifacts(artifacts, project2);
        return new ModuleCompileScope(project2, modules.toArray(new Module[modules.size()]), true);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project2, @NotNull Collection<Artifact> artifacts) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createArtifactsScope"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createArtifactsScope"));
        }
        return ArtifactCompileScope.createArtifactsScope(project2, artifacts, false);
    }

    public static CompileScope createArtifactsScope(@NotNull Project project2, @NotNull Collection<Artifact> artifacts, boolean forceArtifactBuild) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createArtifactsScope"));
        }
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createArtifactsScope"));
        }
        return ArtifactCompileScope.createScopeWithArtifacts(ArtifactCompileScope.createScopeForModulesInArtifacts(project2, artifacts), artifacts, forceArtifactBuild);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<Artifact> artifacts) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createScopeWithArtifacts"));
        }
        return ArtifactCompileScope.createScopeWithArtifacts(baseScope, artifacts, false);
    }

    public static CompileScope createScopeWithArtifacts(CompileScope baseScope, @NotNull Collection<Artifact> artifacts, boolean forceArtifactBuild) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "createScopeWithArtifacts"));
        }
        baseScope.putUserData(ARTIFACTS_KEY, (Object)artifacts.toArray(new Artifact[artifacts.size()]));
        if (forceArtifactBuild) {
            baseScope.putUserData(FORCE_ARTIFACT_BUILD, (Object)Boolean.TRUE);
        }
        return baseScope;
    }

    public static Set<Artifact> getArtifactsToBuild(Project project2, CompileScope compileScope, boolean addIncludedArtifactsWithOutputPathsOnly) {
        Artifact[] artifactsFromScope = ArtifactCompileScope.getArtifacts(compileScope);
        ArtifactManager artifactManager = ArtifactManager.getInstance((Project)project2);
        PackagingElementResolvingContext context = artifactManager.getResolvingContext();
        if (artifactsFromScope != null) {
            return ArtifactCompileScope.addIncludedArtifacts(Arrays.asList(artifactsFromScope), context, addIncludedArtifactsWithOutputPathsOnly);
        }
        Set cached = (Set)compileScope.getUserData(CACHED_ARTIFACTS_KEY);
        if (cached != null) {
            return cached;
        }
        HashSet<Artifact> artifacts = new HashSet<Artifact>();
        HashSet<Module> modules = new HashSet<Module>(Arrays.asList(compileScope.getAffectedModules()));
        List<Module> allModules = Arrays.asList(ModuleManager.getInstance((Project)project2).getModules());
        for (Artifact artifact : artifactManager.getArtifacts()) {
            if (!artifact.isBuildOnMake() || !modules.containsAll(allModules) && !ArtifactCompileScope.containsModuleOutput(artifact, modules, context)) continue;
            artifacts.add(artifact);
        }
        Set<Artifact> result = ArtifactCompileScope.addIncludedArtifacts(artifacts, context, addIncludedArtifactsWithOutputPathsOnly);
        compileScope.putUserData(CACHED_ARTIFACTS_KEY, result);
        return result;
    }

    @Nullable
    public static Artifact[] getArtifacts(CompileScope compileScope) {
        return (Artifact[])compileScope.getUserData(ARTIFACTS_KEY);
    }

    public static boolean isArtifactRebuildForced(@NotNull CompileScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scope", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "isArtifactRebuildForced"));
        }
        return Boolean.TRUE.equals(scope.getUserData(FORCE_ARTIFACT_BUILD));
    }

    private static boolean containsModuleOutput(Artifact artifact, final Set<Module> modules, final PackagingElementResolvingContext context) {
        return !ArtifactUtil.processPackagingElements(artifact, ProductionModuleOutputElementType.ELEMENT_TYPE, new Processor<ModuleOutputPackagingElement>(){

            public boolean process(ModuleOutputPackagingElement moduleOutputPackagingElement) {
                Module module2 = moduleOutputPackagingElement.findModule(context);
                return module2 == null || !modules.contains(module2);
            }
        }, context, true);
    }

    @NotNull
    private static Set<Artifact> addIncludedArtifacts(@NotNull Collection<Artifact> artifacts, @NotNull PackagingElementResolvingContext context, boolean withOutputPathOnly) {
        if (artifacts == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifacts", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "addIncludedArtifacts"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "addIncludedArtifacts"));
        }
        HashSet<Artifact> result = new HashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            ArtifactCompileScope.collectIncludedArtifacts(artifact, context, new HashSet<Artifact>(), result, withOutputPathOnly);
        }
        HashSet<Artifact> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/packaging/impl/compiler/ArtifactCompileScope", "addIncludedArtifacts"));
        }
        return hashSet;
    }

    private static void collectIncludedArtifacts(Artifact artifact, final PackagingElementResolvingContext context, final Set<Artifact> processed2, final Set<Artifact> result, final boolean withOutputPathOnly) {
        if (!processed2.add(artifact)) {
            return;
        }
        if (!withOutputPathOnly || !StringUtil.isEmpty((String)artifact.getOutputPath())) {
            result.add(artifact);
        }
        ArtifactUtil.processPackagingElements(artifact, ArtifactElementType.ARTIFACT_ELEMENT_TYPE, new Processor<ArtifactPackagingElement>(){

            public boolean process(ArtifactPackagingElement element) {
                Artifact included = element.findArtifact(context);
                if (included != null) {
                    ArtifactCompileScope.collectIncludedArtifacts(included, context, processed2, result, withOutputPathOnly);
                }
                return true;
            }
        }, context, false);
    }
}

